/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.normalizer;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.test.normalizer.OutputNormalizer;

public class AsciidoctorAnnotationOutputNormalizer
implements OutputNormalizer {
    private static final Pattern ASCIIDOCTOR_ANNOTATION_PATTERN = Pattern.compile("\\s+// <\\d+>$");

    @Override
    public String normalize(String commandOutput, ExecutionMetadata executionMetadata) {
        return Arrays.stream(commandOutput.split("\\r?\\n", -1)).map(AsciidoctorAnnotationOutputNormalizer::stripAsciidoctorAnnotation).collect(Collectors.joining("\n"));
    }

    private static String stripAsciidoctorAnnotation(String line) {
        if (ASCIIDOCTOR_ANNOTATION_PATTERN.matcher(line).find()) {
            return ASCIIDOCTOR_ANNOTATION_PATTERN.matcher(line).replaceFirst("");
        }
        return line;
    }
}

