/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.runner;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.exemplar.executor.CliCommandExecutor;
import org.gradle.exemplar.executor.CommandExecutor;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.executor.GradleRunnerCommandExecutor;
import org.gradle.exemplar.model.Command;
import org.gradle.exemplar.model.Sample;
import org.gradle.exemplar.test.runner.SamplesRunner;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.model.InitializationError;

public class GradleSamplesRunner
extends SamplesRunner {
    private static final String GRADLE_EXECUTABLE = "gradle";
    @Rule
    public TemporaryFolder tempGradleUserHomeDir = new TemporaryFolder();
    private File customGradleInstallation = null;

    public GradleSamplesRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected boolean isIgnored(Sample child) {
        return !JavaVersion.current().isJava8Compatible();
    }

    @Override
    protected CommandExecutor selectExecutor(ExecutionMetadata executionMetadata, File workingDir, Command command) {
        boolean expectFailure = command.isExpectFailure();
        if (command.getExecutable().equals(GRADLE_EXECUTABLE)) {
            return new GradleRunnerCommandExecutor(workingDir, this.customGradleInstallation, expectFailure);
        }
        return new CliCommandExecutor(workingDir);
    }

    @Override
    @Nullable
    protected File getImplicitSamplesRootDir() {
        String gradleHomeDir = this.getCustomGradleInstallationFromSystemProperty();
        if (System.getProperty("integTest.samplesdir") != null) {
            String samplesRootProperty = System.getProperty("integTest.samplesdir", gradleHomeDir + "/samples");
            return new File(samplesRootProperty);
        }
        if (this.customGradleInstallation != null) {
            return new File(this.customGradleInstallation, "samples");
        }
        return null;
    }

    @Nullable
    private String getCustomGradleInstallationFromSystemProperty() {
        String gradleHomeDirProperty = System.getProperty("integTest.gradleHomeDir");
        if (gradleHomeDirProperty != null) {
            File customGradleInstallationDir = new File(gradleHomeDirProperty);
            if (customGradleInstallationDir.exists()) {
                this.customGradleInstallation = customGradleInstallationDir;
            } else {
                throw new RuntimeException(String.format("Custom Gradle installation dir at %s was not found", gradleHomeDirProperty));
            }
        }
        return gradleHomeDirProperty;
    }
}

