/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.test.runner;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.exemplar.executor.CliCommandExecutor;
import org.gradle.exemplar.executor.CommandExecutionResult;
import org.gradle.exemplar.executor.CommandExecutor;
import org.gradle.exemplar.executor.ExecutionMetadata;
import org.gradle.exemplar.loader.SamplesDiscovery;
import org.gradle.exemplar.model.Command;
import org.gradle.exemplar.model.InvalidSample;
import org.gradle.exemplar.model.Sample;
import org.gradle.exemplar.test.normalizer.OutputNormalizer;
import org.gradle.exemplar.test.runner.SampleModifier;
import org.gradle.exemplar.test.runner.SampleModifiers;
import org.gradle.exemplar.test.runner.SamplesOutputNormalizers;
import org.gradle.exemplar.test.runner.SamplesRoot;
import org.gradle.exemplar.test.runner.Transformer;
import org.gradle.exemplar.test.verifier.AnyOrderLineSegmentedOutputVerifier;
import org.gradle.exemplar.test.verifier.StrictOrderLineSegmentedOutputVerifier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class SamplesRunner
extends ParentRunner<Sample> {
    public static final List<String> SAFE_SYSTEM_PROPERTIES = Arrays.asList("file.separator", "java.home", "java.vendor", "java.version", "line.separator", "os.arch", "os.name", "os.version", "path.separator", "user.dir", "user.home", "user.name");
    private final List<? extends OutputNormalizer> normalizers;
    private final List<SampleModifier> sampleModifiers;
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    public SamplesRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.normalizers = this.instantiateAnnotationClasses(testClass, SamplesOutputNormalizers.class, new Transformer<Class<OutputNormalizer>[], SamplesOutputNormalizers>(){

            @Override
            public Class<OutputNormalizer>[] transform(SamplesOutputNormalizers samplesOutputNormalizers) {
                return samplesOutputNormalizers.value();
            }
        });
        this.sampleModifiers = this.instantiateAnnotationClasses(testClass, SampleModifiers.class, new Transformer<Class<SampleModifier>[], SampleModifiers>(){

            @Override
            public Class<SampleModifier>[] transform(SampleModifiers modifiers) {
                return modifiers.value();
            }
        });
        try {
            this.tmpDir.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary folder " + this.tmpDir.getRoot().getAbsolutePath(), e);
        }
    }

    private <T, A extends Annotation> List<T> instantiateAnnotationClasses(Class testClass, Class<A> annotationClass, Transformer<Class<T>[], A> transformer) {
        A annotation = testClass.getAnnotation(annotationClass);
        ArrayList<T> ret = new ArrayList<T>();
        if (annotation != null) {
            for (Class<T> clazz : transformer.transform(annotation)) {
                try {
                    ret.add(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Could not instantiate " + clazz.getName(), e);
                }
            }
        }
        return ret;
    }

    protected List<Sample> getChildren() {
        return SamplesDiscovery.externalSamples((File)this.getSamplesRootDir());
    }

    protected File getSamplesRootDir() {
        File samplesRootDir;
        SamplesRoot samplesRoot = (SamplesRoot)this.getTestClass().getAnnotation(SamplesRoot.class);
        try {
            samplesRootDir = samplesRoot != null ? new File(samplesRoot.value()) : this.getImplicitSamplesRootDir();
            if (samplesRootDir == null) {
                throw new IllegalArgumentException("Samples root directory is not declared. Please annotate your test class with @SamplesRoot(\"path/to/samples\")");
            }
            if (!samplesRootDir.exists()) {
                throw new IllegalArgumentException("Samples root directory " + samplesRootDir.getAbsolutePath() + " does not exist");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SamplesRunner", e);
        }
        return samplesRootDir;
    }

    @Nullable
    protected File getImplicitSamplesRootDir() {
        return null;
    }

    protected Description describeChild(Sample child) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(Sample sample, RunNotifier notifier) {
        Description childDescription = this.describeChild(sample);
        if (sample instanceof InvalidSample) {
            notifier.fireTestFailure(new Failure(childDescription, (Throwable)((InvalidSample)sample).getException()));
        } else if (this.isIgnored(sample)) {
            notifier.fireTestIgnored(childDescription);
        } else {
            notifier.fireTestStarted(childDescription);
            try {
                Sample testSpecificSample = this.initSample(sample);
                File baseWorkingDir = testSpecificSample.getProjectDir();
                for (Command command : testSpecificSample.getCommands()) {
                    File workingDir = baseWorkingDir;
                    if (command.getExecutionSubdirectory() != null) {
                        workingDir = new File(workingDir, command.getExecutionSubdirectory());
                    }
                    if (command.getExecutable().equals("cd")) {
                        baseWorkingDir = new File(baseWorkingDir, (String)command.getArgs().get(0)).getCanonicalFile();
                        continue;
                    }
                    CommandExecutionResult result = this.execute(this.getExecutionMetadata(testSpecificSample.getProjectDir()), workingDir, command);
                    if (result.getExitCode() != 0 && !command.isExpectFailure()) {
                        Assert.fail((String)String.format("Expected sample invocation to succeed but it failed.%nCommand was: '%s %s'%nWorking directory: '%s'%n[BEGIN OUTPUT]%n%s%n[END OUTPUT]%n", command.getExecutable(), StringUtils.join((Iterable)command.getArgs(), (String)" "), workingDir.getAbsolutePath(), result.getOutput()));
                    } else if (result.getExitCode() == 0 && command.isExpectFailure()) {
                        Assert.fail((String)String.format("Expected sample invocation to fail but it succeeded.%nCommand was: '%s %s'%nWorking directory: '%s'%n[BEGIN OUTPUT]%n%s%n[END OUTPUT]%n", command.getExecutable(), StringUtils.join((Iterable)command.getArgs(), (String)" "), workingDir.getAbsolutePath(), result.getOutput()));
                    }
                    this.verifyOutput(command, result);
                }
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(childDescription, t));
            }
            finally {
                notifier.fireTestFinished(childDescription);
            }
        }
    }

    private Sample initSample(Sample sampleIn) throws IOException {
        File tmpProjectDir = new File(this.tmpDir.getRoot(), sampleIn.getId());
        tmpProjectDir.mkdirs();
        FileUtils.copyDirectory((File)sampleIn.getProjectDir(), (File)tmpProjectDir);
        Sample sample = new Sample(sampleIn.getId(), tmpProjectDir, sampleIn.getCommands());
        for (SampleModifier sampleModifier : this.sampleModifiers) {
            sample = sampleModifier.modify(sample);
        }
        return sample;
    }

    private void verifyOutput(Command command, CommandExecutionResult executionResult) {
        if (command.getExpectedOutput() == null) {
            return;
        }
        String expectedOutput = command.getExpectedOutput();
        String actualOutput = executionResult.getOutput();
        for (OutputNormalizer outputNormalizer : this.normalizers) {
            actualOutput = outputNormalizer.normalize(actualOutput, executionResult.getExecutionMetadata());
        }
        if (command.isAllowDisorderedOutput()) {
            new AnyOrderLineSegmentedOutputVerifier().verify(expectedOutput, actualOutput, command.isAllowAdditionalOutput());
        } else {
            new StrictOrderLineSegmentedOutputVerifier().verify(expectedOutput, actualOutput, command.isAllowAdditionalOutput());
        }
    }

    private CommandExecutionResult execute(ExecutionMetadata executionMetadata, File workingDir, Command command) {
        return this.selectExecutor(executionMetadata, workingDir, command).execute(command, executionMetadata);
    }

    protected CommandExecutor selectExecutor(ExecutionMetadata executionMetadata, File workingDir, Command command) {
        return new CliCommandExecutor(workingDir);
    }

    private ExecutionMetadata getExecutionMetadata(File tempSampleOutputDir) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (String systemPropertyKey : SAFE_SYSTEM_PROPERTIES) {
            systemProperties.put(systemPropertyKey, System.getProperty(systemPropertyKey));
        }
        return new ExecutionMetadata(tempSampleOutputDir, systemProperties);
    }
}

