/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.loader;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.exemplar.InvalidSampleException;
import org.gradle.exemplar.loader.ConfigUtil;
import org.gradle.exemplar.model.Command;

public class CommandsParser {
    private static final String EXECUTABLE = "executable";
    private static final String COMMANDS = "commands";
    private static final String EXECUTION_SUBDIRECTORY = "execution-subdirectory";
    private static final String ARGS = "args";
    private static final String FLAGS = "flags";
    private static final String EXPECT_FAILURE = "expect-failure";
    private static final String ALLOW_ADDITIONAL_OUTPUT = "allow-additional-output";
    private static final String ALLOW_DISORDERED_OUTPUT = "allow-disordered-output";
    private static final String EXPECTED_OUTPUT_FILE = "expected-output-file";
    private static final String USER_INPUTS = "user-inputs";

    public static List<Command> parse(File sampleConfigFile) {
        try {
            Config sampleConfig = ConfigFactory.parseFile((File)sampleConfigFile, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            File sampleProjectDir = sampleConfigFile.getParentFile();
            ArrayList<Command> commands = new ArrayList<Command>();
            if (sampleConfig.hasPath(EXECUTABLE)) {
                commands.add(CommandsParser.parseCommand(sampleConfig, sampleProjectDir));
            } else if (sampleConfig.hasPath(COMMANDS)) {
                for (Config stepConfig : sampleConfig.getConfigList(COMMANDS)) {
                    commands.add(CommandsParser.parseCommand(stepConfig, sampleProjectDir));
                }
            } else {
                throw new InvalidSampleException("A sample must be defined with an 'executable' or 'commands'");
            }
            return commands;
        }
        catch (Exception e) {
            throw new InvalidSampleException(String.format("Could not read sample definition from %s.", sampleConfigFile), e);
        }
    }

    private static Command parseCommand(Config commandConfig, File sampleProjectDir) {
        String executable;
        try {
            executable = commandConfig.getString(EXECUTABLE);
        }
        catch (ConfigException e) {
            throw new InvalidSampleException("'executable' field cannot be empty", (Exception)((Object)e));
        }
        String executionDirectory = ConfigUtil.string(commandConfig, EXECUTION_SUBDIRECTORY, null);
        List<String> commands = ConfigUtil.strings(commandConfig, ARGS, new ArrayList<String>());
        List<String> flags = ConfigUtil.strings(commandConfig, FLAGS, new ArrayList<String>());
        String expectedOutput = null;
        if (commandConfig.hasPath(EXPECTED_OUTPUT_FILE)) {
            File expectedOutputFile = new File(sampleProjectDir, commandConfig.getString(EXPECTED_OUTPUT_FILE));
            try {
                Path path = Paths.get(expectedOutputFile.getAbsolutePath(), new String[0]);
                expectedOutput = new String(Files.readAllBytes(path), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                throw new InvalidSampleException("Could not read sample output file " + expectedOutputFile.getAbsolutePath(), e);
            }
        }
        boolean expectFailures = ConfigUtil.booleanValue(commandConfig, EXPECT_FAILURE, false);
        boolean allowAdditionalOutput = ConfigUtil.booleanValue(commandConfig, ALLOW_ADDITIONAL_OUTPUT, false);
        boolean allowDisorderedOutput = ConfigUtil.booleanValue(commandConfig, ALLOW_DISORDERED_OUTPUT, false);
        List<String> userInputs = ConfigUtil.strings(commandConfig, USER_INPUTS, Collections.emptyList());
        return new Command(executable, executionDirectory, commands, flags, expectedOutput, expectFailures, allowAdditionalOutput, allowDisorderedOutput, userInputs);
    }
}

