/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.loader;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ConfigUtil {
    ConfigUtil() {
    }

    public static Map<String, String> map(Config config, String key, Map<String, String> defaultValues) {
        if (config.hasPath(key)) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            for (Map.Entry entry : config.getConfig(key).entrySet()) {
                props.put((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped().toString());
            }
            return props;
        }
        return defaultValues;
    }

    public static boolean booleanValue(Config config, String key, boolean defaultValue) {
        if (config.hasPath(key)) {
            return Boolean.valueOf(config.getString(key));
        }
        return defaultValue;
    }

    public static String string(Config config, String key, String defaultValue) {
        if (config.hasPath(key)) {
            return config.getString(key);
        }
        return defaultValue;
    }

    public static List<String> strings(Config config, String key, List<String> defaults) {
        if (config.hasPath(key)) {
            Object value = config.getAnyRef(key);
            if (value instanceof List) {
                ArrayList<String> result = new ArrayList<String>();
                for (Object o : (List)value) {
                    result.add(o.toString());
                }
                return result;
            }
            if (value.toString().length() > 0) {
                return Arrays.asList(value.toString().split(" "));
            }
        }
        return defaults;
    }

    public static File file(Config config, File projectDir, String key, File defaultValue) {
        String fileName = ConfigUtil.string(config, key, null);
        if (fileName == null) {
            return defaultValue;
        }
        return new File(projectDir, fileName);
    }
}

