/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.loader.asciidoctor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListImpl;
import org.gradle.exemplar.InvalidSampleException;
import org.gradle.exemplar.model.Command;

public class AsciidoctorCommandsDiscovery {
    private static final String COMMAND_PREFIX = "$ ";

    public static List<Command> extractFromAsciidoctorFile(File documentFile) throws IOException {
        return AsciidoctorCommandsDiscovery.extractFromAsciidoctorFile(documentFile, it -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Command> extractFromAsciidoctorFile(File documentFile, Consumer<OptionsBuilder> action) throws IOException {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        try {
            OptionsBuilder options = OptionsBuilder.options();
            action.accept(options);
            Document document = asciidoctor.loadFile(documentFile, options.asMap());
            List<Command> list = AsciidoctorCommandsDiscovery.extractAsciidocCommands((AbstractBlock)document);
            return list;
        }
        finally {
            asciidoctor.shutdown();
        }
    }

    private static List<Command> extractAsciidocCommands(AbstractBlock testableSampleBlock) {
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayDeque<AbstractBlock> queue = new ArrayDeque<AbstractBlock>();
        queue.add(testableSampleBlock);
        while (!queue.isEmpty()) {
            AbstractBlock node = (AbstractBlock)queue.poll();
            if (node instanceof ListImpl) {
                queue.addAll(((ListImpl)node).getItems());
                continue;
            }
            for (AbstractBlock child : node.getBlocks()) {
                if (child.isBlock() && child.hasRole("sample-command")) {
                    AsciidoctorCommandsDiscovery.parseEmbeddedCommand((Block)child, commands);
                    continue;
                }
                queue.offer(child);
            }
        }
        return commands;
    }

    private static void parseEmbeddedCommand(Block block, List<Command> commands) {
        Map attributes = block.getAttributes();
        String[] lines = block.source().split("\r?\n");
        int pos = 0;
        while ((pos = AsciidoctorCommandsDiscovery.parseOneCommand(lines, pos, attributes, commands)) < lines.length) {
        }
    }

    private static int parseOneCommand(String[] lines, int pos, Map<String, Object> attributes, List<Command> commands) {
        int nextCommand;
        String commandLine = lines[pos];
        if (!commandLine.startsWith(COMMAND_PREFIX)) {
            throw new InvalidSampleException("Inline sample command " + commandLine);
        }
        String[] commandLineWords = commandLine.substring(COMMAND_PREFIX.length()).split("\\s+");
        String executable = commandLineWords[0];
        List<String> args = Collections.emptyList();
        if (commandLineWords.length > 1) {
            args = Arrays.asList(Arrays.copyOfRange(commandLineWords, 1, commandLineWords.length));
        }
        StringBuilder expectedOutput = new StringBuilder();
        for (nextCommand = pos + 1; nextCommand < lines.length && !lines[nextCommand].startsWith(COMMAND_PREFIX); ++nextCommand) {
            if (nextCommand > pos + 1) {
                expectedOutput.append("\n");
            }
            expectedOutput.append(lines[nextCommand]);
        }
        Command command = new Command(executable, null, args, Collections.emptyList(), expectedOutput.toString(), attributes.containsKey("expect-failure"), attributes.containsKey("allow-additional-output"), attributes.containsKey("allow-disordered-output"), attributes.containsKey("user-inputs") ? AsciidoctorCommandsDiscovery.toUserInputs(attributes.get("user-inputs").toString()) : Collections.emptyList());
        commands.add(command);
        return nextCommand;
    }

    private static List<String> toUserInputs(String value) {
        return Arrays.asList(value.split("\\|", -1));
    }
}

