/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.loader.asciidoctor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListImpl;
import org.gradle.exemplar.InvalidSampleException;
import org.gradle.exemplar.model.Command;
import org.gradle.exemplar.model.Sample;

public class AsciidoctorSamplesDiscovery {
    private static final String COMMAND_PREFIX = "$ ";

    public static List<Sample> extractFromAsciidoctorFile(File documentFile) throws IOException {
        return AsciidoctorSamplesDiscovery.extractFromAsciidoctorFile(documentFile, it -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sample> extractFromAsciidoctorFile(File documentFile, Consumer<OptionsBuilder> action) throws IOException {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        try {
            OptionsBuilder options = OptionsBuilder.options();
            action.accept(options);
            Document document = asciidoctor.loadFile(documentFile, options.asMap());
            List<Sample> list = AsciidoctorSamplesDiscovery.processAsciidocSampleBlocks((AbstractBlock)document);
            return list;
        }
        finally {
            asciidoctor.shutdown();
        }
    }

    private static List<Sample> processAsciidocSampleBlocks(AbstractBlock rootNode) throws IOException {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        Path tempDir = Files.createTempDirectory("exemplar-testable-samples", new FileAttribute[0]);
        ArrayDeque<AbstractBlock> queue = new ArrayDeque<AbstractBlock>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            AbstractBlock node = (AbstractBlock)queue.poll();
            List blocks = node.getBlocks();
            if (blocks == null) continue;
            for (AbstractBlock child : blocks) {
                if (child.isBlock() && child.hasRole("testable-sample")) {
                    List<Command> commands = AsciidoctorSamplesDiscovery.extractAsciidocCommands(node);
                    if (commands.isEmpty()) continue;
                    samples.add(AsciidoctorSamplesDiscovery.processSampleNode(child, tempDir, commands));
                    continue;
                }
                queue.offer(child);
            }
        }
        return samples;
    }

    private static Sample processSampleNode(AbstractBlock node, Path tempDir, List<Command> commands) {
        File sampleDir;
        String sampleId;
        if (node.getAttr((Object)"dir") != null) {
            String dir = node.getAttr((Object)"dir").toString();
            sampleId = dir.replaceAll("[/\\\\]", "_");
            sampleDir = new File(dir);
        } else {
            sampleId = RandomStringUtils.randomAlphabetic((int)7);
            try {
                sampleDir = Files.createDirectory(tempDir.resolve(sampleId), new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create temp sample directory under " + tempDir.toString());
            }
            AsciidoctorSamplesDiscovery.extractEmbeddedSampleSources((Block)node, sampleDir);
        }
        return new Sample(sampleId, sampleDir, commands);
    }

    private static List<Command> extractAsciidocCommands(AbstractBlock testableSampleBlock) {
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayDeque<AbstractBlock> queue = new ArrayDeque<AbstractBlock>();
        queue.add(testableSampleBlock);
        while (!queue.isEmpty()) {
            AbstractBlock node = (AbstractBlock)queue.poll();
            if (node instanceof ListImpl) {
                queue.addAll(((ListImpl)node).getItems());
                continue;
            }
            for (AbstractBlock child : node.getBlocks()) {
                if (child.isBlock() && child.hasRole("sample-command")) {
                    AsciidoctorSamplesDiscovery.parseEmbeddedCommand((Block)child, commands);
                    continue;
                }
                queue.offer(child);
            }
        }
        return commands;
    }

    private static void parseEmbeddedCommand(Block block, List<Command> commands) {
        Map attributes = block.getAttributes();
        String[] lines = block.source().split("\r?\n");
        int pos = 0;
        while ((pos = AsciidoctorSamplesDiscovery.parseOneCommand(lines, pos, attributes, commands)) < lines.length) {
        }
    }

    private static int parseOneCommand(String[] lines, int pos, Map<String, Object> attributes, List<Command> commands) {
        int nextCommand;
        String commandLine = lines[pos];
        if (!commandLine.startsWith(COMMAND_PREFIX)) {
            throw new InvalidSampleException("Inline sample command " + commandLine);
        }
        String[] commandLineWords = commandLine.substring(COMMAND_PREFIX.length()).split("\\s+");
        String executable = commandLineWords[0];
        List<String> args = Collections.emptyList();
        if (commandLineWords.length > 1) {
            args = Arrays.asList(Arrays.copyOfRange(commandLineWords, 1, commandLineWords.length));
        }
        StringBuilder expectedOutput = new StringBuilder();
        for (nextCommand = pos + 1; nextCommand < lines.length && !lines[nextCommand].startsWith(COMMAND_PREFIX); ++nextCommand) {
            if (nextCommand > pos + 1) {
                expectedOutput.append("\n");
            }
            expectedOutput.append(lines[nextCommand]);
        }
        Command command = new Command(executable, null, args, Collections.emptyList(), expectedOutput.toString(), attributes.containsKey("expect-failure"), attributes.containsKey("allow-additional-output"), attributes.containsKey("allow-disordered-output"), Collections.emptyList());
        commands.add(command);
        return nextCommand;
    }

    private static void extractEmbeddedSampleSources(Block sampleBlock, File tempSampleDir) {
        for (AbstractBlock block : sampleBlock.getBlocks()) {
            if (block.getStyle() == null || !block.getStyle().equals("source") || block.getTitle() == null) continue;
            File sampleFile = new File(tempSampleDir, block.getTitle());
            File sampleSubfolder = sampleFile.getParentFile();
            if (!sampleSubfolder.exists() && !sampleSubfolder.mkdirs()) {
                throw new IllegalStateException("Couldn't create dir: " + sampleSubfolder);
            }
            try {
                Files.write(sampleFile.toPath(), block.getContent().toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not write sample source file " + sampleFile.toPath().toString());
            }
        }
    }
}

