/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.model;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Command {
    private final String executable;
    private final String executionSubdirectory;
    private final List<String> args;
    private final List<String> flags;
    private final String expectedOutput;
    private final boolean expectFailure;
    private final boolean allowAdditionalOutput;
    private final boolean allowDisorderedOutput;
    private final List<String> userInputs;

    public Command(@Nonnull String executable, @Nullable String executionDirectory, List<String> args, List<String> flags, @Nullable String expectedOutput, boolean expectFailure, boolean allowAdditionalOutput, boolean allowDisorderedOutput, List<String> userInputs) {
        this.executable = executable;
        this.executionSubdirectory = executionDirectory;
        this.args = args;
        this.flags = flags;
        this.expectedOutput = expectedOutput;
        this.expectFailure = expectFailure;
        this.allowAdditionalOutput = allowAdditionalOutput;
        this.allowDisorderedOutput = allowDisorderedOutput;
        this.userInputs = userInputs;
    }

    @Nonnull
    public String getExecutable() {
        return this.executable;
    }

    @Nullable
    public String getExecutionSubdirectory() {
        return this.executionSubdirectory;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    @Nullable
    public String getExpectedOutput() {
        return this.expectedOutput;
    }

    public boolean isExpectFailure() {
        return this.expectFailure;
    }

    public boolean isAllowAdditionalOutput() {
        return this.allowAdditionalOutput;
    }

    public boolean isAllowDisorderedOutput() {
        return this.allowDisorderedOutput;
    }

    public List<String> getUserInputs() {
        return this.userInputs;
    }

    public Builder toBuilder() {
        return new Builder(this.getExecutable(), this.getExecutionSubdirectory(), this.getArgs(), this.getFlags(), this.getExpectedOutput(), this.isExpectFailure(), this.isAllowAdditionalOutput(), this.isAllowDisorderedOutput(), this.getUserInputs());
    }

    public static class Builder {
        private String executable;
        private String executionSubdirectory;
        private List<String> args;
        private List<String> flags;
        private String expectedOutput;
        private boolean expectFailure;
        private boolean allowAdditionalOutput;
        private boolean allowDisorderedOutput;
        private List<String> userInputs;

        private Builder(String executable, String executionDirectory, List<String> args, List<String> flags, String expectedOutput, boolean expectFailure, boolean allowAdditionalOutput, boolean allowDisorderedOutput, List<String> userInputs) {
            this.executable = executable;
            this.executionSubdirectory = executionDirectory;
            this.args = args;
            this.flags = flags;
            this.expectedOutput = expectedOutput;
            this.expectFailure = expectFailure;
            this.allowAdditionalOutput = allowAdditionalOutput;
            this.allowDisorderedOutput = allowDisorderedOutput;
            this.userInputs = userInputs;
        }

        public Builder setExecutable(String executable) {
            this.executable = executable;
            return this;
        }

        public Builder setExecutionSubdirectory(String executionSubdirectory) {
            this.executionSubdirectory = executionSubdirectory;
            return this;
        }

        public Builder setArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder setFlags(List<String> flags) {
            this.flags = flags;
            return this;
        }

        public Builder setExpectedOutput(String expectedOutput) {
            this.expectedOutput = expectedOutput;
            return this;
        }

        public Builder setExpectFailure(boolean expectFailure) {
            this.expectFailure = expectFailure;
            return this;
        }

        public Builder setAllowAdditionalOutput(boolean allowAdditionalOutput) {
            this.allowAdditionalOutput = allowAdditionalOutput;
            return this;
        }

        public Builder setAllowDisorderedOutput(boolean allowDisorderedOutput) {
            this.allowDisorderedOutput = allowDisorderedOutput;
            return this;
        }

        public Command build() {
            return new Command(this.executable, this.executionSubdirectory, this.args, this.flags, this.expectedOutput, this.expectFailure, this.allowAdditionalOutput, this.allowDisorderedOutput, this.userInputs);
        }
    }
}

