/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.exemplar.loader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.exemplar.loader.CommandsParser;
import org.gradle.exemplar.loader.asciidoctor.AsciidoctorSamplesDiscovery;
import org.gradle.exemplar.model.Command;
import org.gradle.exemplar.model.InvalidSample;
import org.gradle.exemplar.model.Sample;

public class SamplesDiscovery {
    public static List<Sample> externalSamples(File rootSamplesDir) {
        return SamplesDiscovery.filteredExternalSamples(rootSamplesDir, new String[]{"sample.conf"}, true);
    }

    public static List<Sample> filteredExternalSamples(File rootSamplesDir, String[] fileExtensions, boolean recursive) {
        Collection sampleConfigFiles = FileUtils.listFiles((File)rootSamplesDir, (String[])fileExtensions, (boolean)recursive);
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (File sampleConfigFile : sampleConfigFiles) {
            String id = SamplesDiscovery.generateSampleId(rootSamplesDir, sampleConfigFile);
            try {
                List<Command> commands = CommandsParser.parse(sampleConfigFile);
                File sampleProjectDir = sampleConfigFile.getParentFile();
                samples.add(new Sample(id, sampleProjectDir, commands));
            }
            catch (Exception e) {
                samples.add(new InvalidSample(id, e));
            }
        }
        SamplesDiscovery.sortSamples(samples);
        return samples;
    }

    public static List<Sample> embeddedSamples(File asciidocSrcDir) throws IOException {
        return SamplesDiscovery.filteredEmbeddedSamples(asciidocSrcDir, new String[]{"adoc", "asciidoc"}, true);
    }

    public static List<Sample> filteredEmbeddedSamples(File rootSamplesDir, String[] fileExtensions, boolean recursive) throws IOException {
        Collection sampleConfigFiles = FileUtils.listFiles((File)rootSamplesDir, (String[])fileExtensions, (boolean)recursive);
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (File sampleConfigFile : sampleConfigFiles) {
            samples.addAll(AsciidoctorSamplesDiscovery.extractFromAsciidoctorFile(sampleConfigFile));
        }
        SamplesDiscovery.sortSamples(samples);
        return samples;
    }

    private static String generateSampleId(File rootSamplesDir, File scenarioFile) {
        String prefix = rootSamplesDir.toPath().relativize(scenarioFile.getParentFile().toPath()).toString().replaceAll("[/\\\\]", "_");
        return prefix + "_" + FilenameUtils.removeExtension((String)scenarioFile.getName());
    }

    private static void sortSamples(List<Sample> samples) {
        Collections.sort(samples, new SampleComparator());
    }

    private static class SampleComparator
    implements Comparator<Sample> {
        private SampleComparator() {
        }

        @Override
        public int compare(Sample s1, Sample s2) {
            return s1.getId().compareTo(s2.getId());
        }
    }
}

