/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Connection
implements Closeable {
    private final Socket socket;
    private final DataOutputStream outputStream;
    private final DataInputStream inputStream;

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new DataOutputStream(socket.getOutputStream());
        this.inputStream = new DataInputStream(socket.getInputStream());
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public byte readByte() throws IOException {
        return this.inputStream.readByte();
    }

    public void writeByte(byte value) throws IOException {
        this.outputStream.writeByte(value);
    }

    public int readInt() throws IOException {
        return this.inputStream.readInt();
    }

    public void writeInt(int value) throws IOException {
        this.outputStream.writeInt(value);
    }

    public long readLong() throws IOException {
        return this.inputStream.readLong();
    }

    public void writeLong(long value) throws IOException {
        this.outputStream.writeLong(value);
    }

    public String readString() throws IOException {
        return this.inputStream.readUTF();
    }

    public void writeString(String value) throws IOException {
        this.outputStream.writeUTF(value);
    }

    public List<String> readStrings() throws IOException {
        int count = this.inputStream.readInt();
        ArrayList<String> strings = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            strings.add(this.inputStream.readUTF());
        }
        return strings;
    }

    public void writeStrings(List<String> strings) throws IOException {
        this.outputStream.writeInt(strings.size());
        for (String s : strings) {
            this.outputStream.writeUTF(s);
        }
    }

    public void flush() throws IOException {
        this.outputStream.flush();
        this.socket.getOutputStream().flush();
    }
}

