/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.ConnectionParameters;
import org.gradle.profiler.client.protocol.Message;
import org.gradle.profiler.client.protocol.SyncCompleted;
import org.gradle.profiler.client.protocol.SyncParameters;
import org.gradle.profiler.client.protocol.SyncStarted;

public class Serializer {
    private static final Object NULL = new Object();
    private final String peerName;
    private final Connection connection;

    public Serializer(String peerName, Connection connection) {
        this.peerName = peerName;
        this.connection = connection;
    }

    public void send(SyncStarted message) {
        try {
            this.connection.writeByte((byte)1);
            this.connection.writeInt(message.getId());
            this.connection.flush();
        }
        catch (IOException e) {
            throw this.couldNotWrite(e);
        }
    }

    public void send(SyncCompleted message) {
        try {
            this.connection.writeByte((byte)2);
            this.connection.writeInt(message.getId());
            this.connection.writeLong(message.getDurationMillis());
            this.connection.flush();
        }
        catch (IOException e) {
            throw this.couldNotWrite(e);
        }
    }

    public void send(SyncParameters message) {
        try {
            this.connection.writeByte((byte)3);
            this.connection.writeStrings(message.getGradleArgs());
            this.connection.writeStrings(message.getJvmArgs());
            this.connection.flush();
        }
        catch (IOException e) {
            throw this.couldNotWrite(e);
        }
    }

    public void send(ConnectionParameters message) {
        try {
            this.connection.writeByte((byte)4);
            this.connection.writeString(message.getGradleInstallation().getPath());
            this.connection.flush();
        }
        catch (IOException e) {
            throw this.couldNotWrite(e);
        }
    }

    private RuntimeException couldNotWrite(IOException e) {
        return new RuntimeException(String.format("Could not write to %s.", this.peerName), e);
    }

    public <T extends Message> T receive(Class<T> type, Duration timeout) {
        Object result;
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Thread reader = new Thread(() -> {
            try {
                Object result;
                try {
                    result = this.receive();
                }
                catch (RuntimeException e) {
                    result = e;
                }
                queue.put(result);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        reader.start();
        try {
            result = queue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (result == null) {
                reader.interrupt();
                throw new IllegalStateException(String.format("Timeout waiting to receive message from %s.", this.peerName));
            }
            reader.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (result == NULL) {
            throw new IllegalStateException(String.format("Connection to %s has closed.", this.peerName));
        }
        return (T)((Message)type.cast(result));
    }

    private Object receive() {
        try {
            byte tag;
            try {
                tag = this.connection.readByte();
            }
            catch (EOFException e) {
                return NULL;
            }
            switch (tag) {
                case 1: {
                    int startId = this.connection.readInt();
                    return new SyncStarted(startId);
                }
                case 2: {
                    int completeId = this.connection.readInt();
                    long durationMillis = this.connection.readLong();
                    return new SyncCompleted(completeId, durationMillis);
                }
                case 3: {
                    List<String> gradleArgs = this.connection.readStrings();
                    List<String> jvmArgs = this.connection.readStrings();
                    return new SyncParameters(gradleArgs, jvmArgs);
                }
                case 4: {
                    String gradleHome = this.connection.readString();
                    return new ConnectionParameters(new File(gradleHome));
                }
            }
            throw new RuntimeException(String.format("Received unexpected message from %s.", this.peerName));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not read from %s.", this.peerName), e);
        }
    }
}

