/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.time.Duration;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.ConnectionParameters;
import org.gradle.profiler.client.protocol.Serializer;
import org.gradle.profiler.client.protocol.SyncCompleted;
import org.gradle.profiler.client.protocol.SyncParameters;
import org.gradle.profiler.client.protocol.SyncStarted;

public class Client {
    public static final Client INSTANCE = new Client();
    private final Object lock = new Object();
    private Connection connection;
    private Serializer serializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int port) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection != null) {
                throw new IllegalStateException("This client is already connected.");
            }
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
                this.connection = new Connection(socket);
                this.serializer = new Serializer("controller process", this.connection);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not connect to controller process.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SyncStarted message) {
        Object object = this.lock;
        synchronized (object) {
            this.serializer.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SyncCompleted message) {
        Object object = this.lock;
        synchronized (object) {
            this.serializer.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncParameters receiveSyncParameters(Duration timeout) {
        Object object = this.lock;
        synchronized (object) {
            return this.serializer.receive(SyncParameters.class, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionParameters receiveConnectionParameters(Duration timeout) {
        Object object = this.lock;
        synchronized (object) {
            return this.serializer.receive(ConnectionParameters.class, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }
}

