/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.ConnectionParameters;
import org.gradle.profiler.client.protocol.Serializer;
import org.gradle.profiler.client.protocol.SyncCompleted;
import org.gradle.profiler.client.protocol.SyncParameters;
import org.gradle.profiler.client.protocol.SyncStarted;

public class ServerConnection
implements Closeable {
    private final Connection connection;
    private final Serializer serializer;

    public ServerConnection(String peerName, Connection connection) {
        this.connection = connection;
        this.serializer = new Serializer(peerName, connection);
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public void send(SyncParameters syncParameters) {
        this.serializer.send(syncParameters);
    }

    public void send(ConnectionParameters connectionParameters) {
        this.serializer.send(connectionParameters);
    }

    public SyncStarted receiveSyncStarted(Duration timeout) {
        return this.serializer.receive(SyncStarted.class, timeout);
    }

    public SyncCompleted receiveSyncCompeted(Duration timeout) {
        return this.serializer.receive(SyncCompleted.class, timeout);
    }
}

