/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.time.Duration;
import org.gradle.profiler.client.protocol.Connection;
import org.gradle.profiler.client.protocol.messages.GradleInvocationParameters;
import org.gradle.profiler.client.protocol.messages.Message;
import org.gradle.profiler.client.protocol.messages.StudioAgentConnectionParameters;
import org.gradle.profiler.client.protocol.messages.StudioRequest;
import org.gradle.profiler.client.protocol.serialization.MessageProtocolHandler;

public class Client
implements Closeable {
    private final Object lock = new Object();
    private final Connection connection;
    private final MessageProtocolHandler protocolHandler;

    public Client(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            this.connection = new Connection(socket);
            this.protocolHandler = new MessageProtocolHandler("controller process", this.connection);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not connect to controller process.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        Object object = this.lock;
        synchronized (object) {
            this.protocolHandler.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GradleInvocationParameters receiveSyncParameters(Duration timeout) {
        Object object = this.lock;
        synchronized (object) {
            return this.protocolHandler.receive(GradleInvocationParameters.class, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StudioAgentConnectionParameters receiveConnectionParameters(Duration timeout) {
        Object object = this.lock;
        synchronized (object) {
            return this.protocolHandler.receive(StudioAgentConnectionParameters.class, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StudioRequest receiveStudioRequest(Duration timeout) {
        Object object = this.lock;
        synchronized (object) {
            return this.protocolHandler.receive(StudioRequest.class, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.connection.close();
        }
    }
}

