/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.client.protocol;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Connection
implements Closeable {
    private final Socket socket;
    private final DataOutputStream outputStream;
    private final DataInputStream inputStream;

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = new DataOutputStream(socket.getOutputStream());
        this.inputStream = new DataInputStream(socket.getInputStream());
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public byte readByte(int timeout) throws IOException {
        return this.read(this.inputStream::readByte, timeout);
    }

    public void writeByte(byte value) throws IOException {
        this.outputStream.writeByte(value);
    }

    public int readInt(int timeout) throws IOException {
        return this.read(this.inputStream::readInt, timeout);
    }

    public void writeInt(int value) throws IOException {
        this.outputStream.writeInt(value);
    }

    public long readLong(int timeout) throws IOException {
        return this.read(this.inputStream::readLong, timeout);
    }

    public void writeLong(long value) throws IOException {
        this.outputStream.writeLong(value);
    }

    public String readString(int timeout) throws IOException {
        return this.read(this.inputStream::readUTF, timeout);
    }

    public void writeString(String value) throws IOException {
        this.outputStream.writeUTF(value);
    }

    public List<String> readStrings(int timeout) throws IOException {
        return this.read(() -> {
            int count = this.inputStream.readInt();
            ArrayList<String> strings = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                strings.add(this.inputStream.readUTF());
            }
            return strings;
        }, timeout);
    }

    public void writeStrings(List<String> strings) throws IOException {
        this.outputStream.writeInt(strings.size());
        for (String s : strings) {
            this.outputStream.writeUTF(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T read(SocketReadAction<T> supplier, int timeout) throws IOException {
        Socket socket = this.socket;
        synchronized (socket) {
            this.socket.setSoTimeout(timeout);
            T t = supplier.get();
            return t;
            finally {
                this.socket.setSoTimeout(0);
            }
        }
    }

    public void flush() throws IOException {
        this.outputStream.flush();
        this.socket.getOutputStream().flush();
    }

    private static interface SocketReadAction<T> {
        public T get() throws IOException;
    }
}

