/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.GradleBuildInvoker;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerFactory;
import org.gradle.profiler.report.CsvGenerator;

class CommandLineParser {
    CommandLineParser() {
    }

    @Nullable
    public InvocationSettings parseSettings(String[] args) throws IOException, SettingsNotAvailableException {
        OptionSet parsedOptions;
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOption = parser.acceptsAll(Arrays.asList("h", "help"), "Show this usage information").forHelp();
        OptionSpecBuilder versionOption = parser.acceptsAll(Arrays.asList("v", "version"), "Display version information");
        parser.nonOptions("The scenarios or task names to run");
        ArgumentAcceptingOptionSpec projectOption = parser.accepts("project-dir", "The directory containing the build to run").withRequiredArg().ofType(File.class).defaultsTo((Object)new File(".").getCanonicalFile(), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec gradleVersionOption = parser.accepts("gradle-version", "Gradle version or installation to use to run build").withRequiredArg();
        ArgumentAcceptingOptionSpec gradleUserHomeOption = parser.accepts("gradle-user-home", "The Gradle user home to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("gradle-user-home"), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec studioHomeOption = parser.accepts("studio-install-dir", "The Studio installation to use").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec scenarioFileOption = parser.accepts("scenario-file", "Scenario definition file to use").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec sysPropOption = parser.accepts("D", "Defines a system property").withRequiredArg();
        ArgumentAcceptingOptionSpec outputDirOption = parser.accepts("output-dir", "Directory to write results to").withRequiredArg().ofType(File.class).defaultsTo((Object)this.findOutputDir(), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec warmupsOption = parser.accepts("warmups", "Number of warm-up build to run for each scenario").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec iterationsOption = parser.accepts("iterations", "Number of builds to run for each scenario").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec profilerOption = parser.accepts("profile", "Collect profiling information using profiler (" + String.join((CharSequence)", ", ProfilerFactory.getAvailableProfilers()) + ")").withRequiredArg().defaultsTo((Object)"jfr", (Object[])new String[0]);
        ProfilerFactory.configureParser(parser);
        OptionSpecBuilder noDifferentialFlamegraphOption = parser.accepts("no-diffs", "Do not generate differential flame graphs");
        OptionSpecBuilder benchmarkOption = parser.accepts("benchmark", "Collect benchmark metrics");
        ArgumentAcceptingOptionSpec benchmarkBuildOperation = parser.accepts("measure-build-op", "Collect benchmark metrics for build operation").withRequiredArg();
        OptionSpecBuilder noDaemonOption = parser.accepts("no-daemon", "Do not use the Gradle daemon");
        OptionSpecBuilder coldDaemonOption = parser.accepts("cold-daemon", "Use a cold Gradle daemon");
        OptionSpecBuilder cliOption = parser.accepts("cli", "Uses the command-line client to connect to the daemon");
        OptionSpecBuilder measureGarbageCollectionOption = parser.accepts("measure-gc", "Measure the GC time during each invocation");
        OptionSpecBuilder measureConfigTimeOption = parser.accepts("measure-config-time", "Include a breakdown of configuration time in benchmark results");
        OptionSpecBuilder dryRunOption = parser.accepts("dry-run", "Verify configuration");
        OptionSpecBuilder bazelOption = parser.accepts("bazel", "Benchmark scenarios using Bazel");
        OptionSpecBuilder buckOption = parser.accepts("buck", "Benchmark scenarios using buck");
        OptionSpecBuilder mavenOption = parser.accepts("maven", "Benchmark scenarios using Maven");
        ArgumentAcceptingOptionSpec csvFormatOption = parser.accepts("csv-format", "The CSV format produced (" + Stream.of(CsvGenerator.Format.values()).map(Enum::toString).collect(Collectors.joining(", ")) + ")").withRequiredArg().defaultsTo((Object)"wide", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec benchmarkTitleOption = parser.accepts("title", "Title to show on benchmark report").withOptionalArg().ofType(String.class);
        try {
            parsedOptions = parser.parse(args);
        }
        catch (OptionException e) {
            return this.fail(parser, e.getMessage());
        }
        if (parsedOptions.has((OptionSpec)helpOption)) {
            this.showHelp(parser);
            return null;
        }
        if (parsedOptions.has((OptionSpec)versionOption)) {
            this.showVersion();
            return null;
        }
        File projectDir = (File)parsedOptions.valueOf((OptionSpec)projectOption);
        boolean hasProfiler = parsedOptions.has((OptionSpec)profilerOption);
        ProfilerFactory profilerFactory = ProfilerFactory.NONE;
        if (hasProfiler) {
            List profilersList = parsedOptions.valuesOf((OptionSpec)profilerOption);
            profilerFactory = ProfilerFactory.of(profilersList);
        }
        Profiler profiler = profilerFactory.createFromOptions(parsedOptions);
        boolean generateDiffs = !parsedOptions.has((OptionSpec)noDifferentialFlamegraphOption) && hasProfiler && profiler.isCreatesStacksFiles();
        boolean benchmark = parsedOptions.has((OptionSpec)benchmarkOption);
        if (!benchmark && !hasProfiler) {
            return this.fail(parser, "Neither --profile or --benchmark specified.");
        }
        File outputDir = (File)parsedOptions.valueOf((OptionSpec)outputDirOption);
        File gradleUserHome = (File)parsedOptions.valueOf((OptionSpec)gradleUserHomeOption);
        Integer warmups = (Integer)parsedOptions.valueOf((OptionSpec)warmupsOption);
        Integer iterations = (Integer)parsedOptions.valueOf((OptionSpec)iterationsOption);
        boolean measureGarbageCollection = parsedOptions.has((OptionSpec)measureGarbageCollectionOption);
        boolean measureConfig = parsedOptions.has((OptionSpec)measureConfigTimeOption);
        List benchmarkedBuildOperations = parsedOptions.valuesOf((OptionSpec)benchmarkBuildOperation);
        List<String> targetNames = parsedOptions.nonOptionArguments().stream().map(Object::toString).collect(Collectors.toList());
        List gradleVersions = parsedOptions.valuesOf((OptionSpec)gradleVersionOption);
        File scenarioFile = (File)parsedOptions.valueOf((OptionSpec)scenarioFileOption);
        File studioInstallDir = (File)parsedOptions.valueOf((OptionSpec)studioHomeOption);
        GradleBuildInvoker gradleInvoker = GradleBuildInvoker.ToolingApi;
        if (parsedOptions.has((OptionSpec)cliOption)) {
            gradleInvoker = GradleBuildInvoker.Cli;
        }
        if (parsedOptions.has((OptionSpec)coldDaemonOption)) {
            gradleInvoker = gradleInvoker.withColdDaemon();
        }
        if (parsedOptions.has((OptionSpec)noDaemonOption)) {
            gradleInvoker = GradleBuildInvoker.CliNoDaemon;
        }
        BuildInvoker invoker = gradleInvoker;
        if (parsedOptions.has((OptionSpec)bazelOption)) {
            invoker = BuildInvoker.Bazel;
        }
        if (parsedOptions.has((OptionSpec)buckOption)) {
            invoker = BuildInvoker.Buck;
        }
        if (parsedOptions.has((OptionSpec)mavenOption)) {
            invoker = BuildInvoker.Maven;
        }
        boolean dryRun = parsedOptions.has((OptionSpec)dryRunOption);
        LinkedHashMap<String, String> sysProperties = new LinkedHashMap<String, String>();
        for (String value : parsedOptions.valuesOf((OptionSpec)sysPropOption)) {
            int sep = value.indexOf("=");
            if (sep < 0) {
                sysProperties.put(value, "true");
                continue;
            }
            sysProperties.put(value.substring(0, sep), value.substring(sep + 1));
        }
        CsvGenerator.Format csvFormat = CsvGenerator.Format.parse((String)parsedOptions.valueOf((OptionSpec)csvFormatOption));
        String benchmarkTitle = (String)parsedOptions.valueOf((OptionSpec)benchmarkTitleOption);
        return new InvocationSettings.InvocationSettingsBuilder().setProjectDir(projectDir).setProfiler(profiler).setGenerateDiffs(generateDiffs).setBenchmark(benchmark).setOutputDir(outputDir).setInvoker(invoker).setDryRun(dryRun).setScenarioFile(scenarioFile).setVersions(gradleVersions).setTargets(targetNames).setSysProperties(sysProperties).setGradleUserHome(gradleUserHome).setStudioInstallDir(studioInstallDir).setWarmupCount(warmups).setIterations(iterations).setMeasureGarbageCollection(measureGarbageCollection).setMeasureConfigTime(measureConfig).setMeasuredBuildOperations(benchmarkedBuildOperations).setCsvFormat(csvFormat).setBenchmarkTitle(benchmarkTitle).build();
    }

    private File findOutputDir() {
        File outputDir = new File("profile-out");
        if (!outputDir.exists()) {
            return outputDir;
        }
        int i = 2;
        while ((outputDir = new File("profile-out-" + i)).exists()) {
            ++i;
        }
        return outputDir;
    }

    private InvocationSettings fail(OptionParser parser, String message) throws IOException {
        System.out.println(message);
        System.out.println();
        this.showHelp(parser);
        throw new SettingsNotAvailableException();
    }

    private void showHelp(OptionParser parser) throws IOException {
        parser.printHelpOn((OutputStream)System.out);
    }

    private void showVersion() {
        System.out.printf("Gradle Profiler version %s%n", CommandLineParser.class.getPackage().getImplementationVersion());
    }

    public static class SettingsNotAvailableException
    extends RuntimeException {
    }
}

