/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.GradleClientSpec;
import org.gradle.profiler.GradleDaemonReuse;

public class GradleBuildInvoker
extends BuildInvoker {
    public static final GradleBuildInvoker ToolingApi = new GradleBuildInvoker(GradleClientSpec.ToolingApi, GradleDaemonReuse.WarmDaemonOnly);
    public static final GradleBuildInvoker Cli = new GradleBuildInvoker(GradleClientSpec.GradleCli, GradleDaemonReuse.WarmDaemonOnly);
    public static final GradleBuildInvoker CliNoDaemon = new GradleBuildInvoker(GradleClientSpec.GradleCliNoDaemon, GradleDaemonReuse.ColdDaemonOnly){

        @Override
        public String toString() {
            return "`gradle` command with --no-daemon";
        }
    };
    static final GradleBuildInvoker AndroidStudio = new GradleBuildInvoker(GradleClientSpec.AndroidStudio, GradleDaemonReuse.WarmDaemonOnly);
    private final GradleClientSpec client;
    private final GradleDaemonReuse daemonReuse;

    private GradleBuildInvoker(GradleClientSpec client, GradleDaemonReuse daemonReuse) {
        this.client = client;
        this.daemonReuse = daemonReuse;
    }

    @Override
    public boolean allowsCleanupBetweenBuilds() {
        return !this.isReuseDaemon();
    }

    public String toString() {
        if (this.daemonReuse == GradleDaemonReuse.ColdDaemonOnly) {
            return this.client + " with cold daemon";
        }
        return this.client.toString();
    }

    public GradleBuildInvoker withColdDaemon() {
        if (this.daemonReuse == GradleDaemonReuse.ColdDaemonOnly) {
            return this;
        }
        return new GradleBuildInvoker(this.client, GradleDaemonReuse.ColdDaemonOnly);
    }

    public GradleClientSpec getClient() {
        return this.client;
    }

    public GradleDaemonReuse getDaemonReuse() {
        return this.daemonReuse;
    }

    public boolean isDoesNotUseDaemon() {
        return !this.getClient().isUsesDaemon();
    }

    public boolean isReuseDaemon() {
        return this.getDaemonReuse() == GradleDaemonReuse.WarmDaemonOnly;
    }

    public boolean isShouldCleanUpDaemon() {
        return this.getDaemonReuse() != GradleDaemonReuse.WarmDaemonOnly;
    }

    @Override
    public int benchmarkWarmUps() {
        if (!this.isReuseDaemon()) {
            return 1;
        }
        return super.benchmarkWarmUps();
    }

    @Override
    public int profileWarmUps() {
        if (!this.isReuseDaemon()) {
            return 1;
        }
        return super.profileWarmUps();
    }
}

