/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

class TeeOutputStream
extends OutputStream {
    private final List<OutputStream> targets;

    public TeeOutputStream(OutputStream ... targets) {
        this.targets = Arrays.asList(targets);
    }

    @Override
    public void write(int b) throws IOException {
        this.withAll(stream -> stream.write(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.withAll(stream -> stream.write(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        this.withAll(stream -> stream.flush());
    }

    @Override
    public void close() throws IOException {
        this.withAll(stream -> stream.close());
    }

    private void withAll(IOAction action) throws IOException {
        IOException failure = null;
        for (OutputStream target : this.targets) {
            try {
                action.withStream(target);
            }
            catch (IOException e) {
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    private static interface IOAction {
        public void withStream(OutputStream var1) throws IOException;
    }
}

