/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.EventType;
import org.gradle.profiler.flamegraph.FlameGraphGenerator;
import org.gradle.profiler.flamegraph.FlameGraphSanitizer;
import org.gradle.profiler.flamegraph.Stacks;
import org.gradle.profiler.jfr.JfrToStacksConverter;

public class AsyncProfilerController
implements InstrumentingProfiler.SnapshotCapturingProfilerController {
    private final AsyncProfilerConfig profilerConfig;
    private final ScenarioSettings scenarioSettings;
    private final JfrToStacksConverter stacksConverter;
    private final FlameGraphGenerator flameGraphGenerator;
    private final ImmutableMap<DetailLevel, FlameGraphSanitizer> flameGraphSanitizers;
    private final File outputFile;
    private final AsyncProfilerOutputType outputType;

    public AsyncProfilerController(AsyncProfilerConfig profilerConfig, ScenarioSettings scenarioSettings) {
        this.profilerConfig = profilerConfig;
        this.scenarioSettings = scenarioSettings;
        FlameGraphSanitizer rawFlamegraphSanitizer = FlameGraphSanitizer.raw(new FlameGraphSanitizer.SanitizeFunction[0]);
        FlameGraphSanitizer simplifiedFlamegraphSanitizer = profilerConfig.isIncludeSystemThreads() ? FlameGraphSanitizer.simplified(new FlameGraphSanitizer.SanitizeFunction[0]) : FlameGraphSanitizer.simplified(new RemoveSystemThreads());
        this.flameGraphSanitizers = ImmutableMap.of((Object)((Object)DetailLevel.RAW), (Object)rawFlamegraphSanitizer, (Object)((Object)DetailLevel.SIMPLIFIED), (Object)simplifiedFlamegraphSanitizer);
        this.stacksConverter = new JfrToStacksConverter((Map<DetailLevel, FlameGraphSanitizer>)this.flameGraphSanitizers);
        this.flameGraphGenerator = new FlameGraphGenerator();
        this.outputType = AsyncProfilerOutputType.from(profilerConfig, scenarioSettings.getScenario());
        this.outputFile = this.outputType.outputFileFor(scenarioSettings);
    }

    public String getName() {
        return "async profiler";
    }

    @Override
    public void startRecording(String pid) throws IOException, InterruptedException {
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add((Object[])new String[]{this.getProfilerScript().getAbsolutePath(), "start", "-e", this.profilerConfig.getJoinedEvents(), "-i", String.valueOf(this.profilerConfig.getInterval()), "-j", String.valueOf(this.profilerConfig.getStackDepth()), "--" + this.profilerConfig.getCounter().name().toLowerCase(Locale.ROOT), "-a", "-o", this.outputType.getCommandLineOption(), "-f", this.outputType.individualOutputFileFor(this.scenarioSettings).getAbsolutePath()});
        if (this.profilerConfig.getEvents().contains("alloc")) {
            arguments.add((Object[])new String[]{"--alloc", String.valueOf(this.profilerConfig.getAllocSampleSize())});
        }
        if (this.profilerConfig.getEvents().contains("lock")) {
            arguments.add((Object[])new String[]{"--lock", String.valueOf(this.profilerConfig.getLockThreshold())});
        }
        arguments.add((Object)pid);
        new CommandExec().run((Collection<String>)arguments.build());
    }

    @Override
    public void stopRecording(String pid) {
        new CommandExec().run(this.getProfilerScript().getAbsolutePath(), "stop", "-o", this.outputType.getCommandLineOption(), "-f", this.outputType.individualOutputFileFor(this.scenarioSettings).getAbsolutePath(), "-a", pid);
    }

    @Override
    public void captureSnapshot(String pid) {
    }

    @Override
    public void stopSession() {
        List<Stacks> stacks = this.generateStacks(this.scenarioSettings.getProfilerOutputBaseDir(), this.scenarioSettings.getProfilerOutputBaseName());
        this.flameGraphGenerator.generateGraphs(this.scenarioSettings.getProfilerOutputBaseDir(), stacks);
    }

    private List<Stacks> generateStacks(File outputDir, String outputBaseName) {
        if (this.outputType == AsyncProfilerOutputType.JFR) {
            List<Stacks> stacks = this.stacksConverter.generateStacks(this.outputFile, outputBaseName);
            if (stacks.isEmpty()) {
                this.failOnEmptyStacks();
            }
            return stacks;
        }
        this.validateStacks();
        ArrayList<Stacks> collectedStacks = new ArrayList<Stacks>();
        for (String event : this.profilerConfig.getEvents()) {
            EventType jfrEventType = this.convertAsyncEventToJfrEvent(event);
            for (DetailLevel level : DetailLevel.values()) {
                collectedStacks.add(this.sanitizeStacks(outputDir, outputBaseName, this.outputFile, jfrEventType, level));
            }
        }
        return collectedStacks;
    }

    private Stacks sanitizeStacks(File outputDir, String outputBaseName, File stacksFileToConvert, EventType jfrEventType, DetailLevel level) {
        FlameGraphSanitizer flamegraphSanitizer = (FlameGraphSanitizer)this.flameGraphSanitizers.get((Object)level);
        String eventFileBaseName = outputBaseName + Stacks.postFixFor(jfrEventType, level);
        File sanitizedStacksFile = new File(outputDir, eventFileBaseName + "-stacks.txt");
        flamegraphSanitizer.sanitize(stacksFileToConvert, sanitizedStacksFile);
        return new Stacks(sanitizedStacksFile, jfrEventType, level, eventFileBaseName);
    }

    private EventType convertAsyncEventToJfrEvent(String event) {
        switch (event) {
            case "cpu": {
                return EventType.CPU;
            }
            case "wall": {
                return EventType.CPU;
            }
            case "alloc": {
                return EventType.ALLOCATION;
            }
            case "lock": {
                return EventType.MONITOR_BLOCKED;
            }
        }
        return EventType.CPU;
    }

    private void validateStacks() {
        if (!this.outputFile.isFile() || this.outputFile.length() == 0L) {
            this.failOnEmptyStacks();
        }
    }

    private void failOnEmptyStacks() {
        throw new RuntimeException("No stacks have been captured by Async profiler. If you are on Linux, you may need to set two runtime variables:\n# sysctl kernel.perf_event_paranoid=1\n# sysctl kernel.kptr_restrict=0");
    }

    private File getProfilerScript() {
        return new File(this.profilerConfig.getProfilerHome(), "profiler.sh");
    }

    private static final class RemoveSystemThreads
    implements FlameGraphSanitizer.SanitizeFunction {
        private RemoveSystemThreads() {
        }

        @Override
        public List<String> map(List<String> stack) {
            for (String frame : stack) {
                if (!frame.contains("GCTaskThread") && !frame.contains("JavaThread")) continue;
                return Collections.emptyList();
            }
            return stack;
        }
    }
}

