/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public abstract class AbstractCleanupMutator
implements BuildMutator {
    private final CleanupSchedule schedule;

    public AbstractCleanupMutator(CleanupSchedule schedule) {
        this.schedule = schedule;
    }

    @Override
    public void validate(BuildInvoker invoker) {
        if (this.schedule != CleanupSchedule.SCENARIO && !invoker.allowsCleanupBetweenBuilds()) {
            throw new IllegalStateException(this + " is not allowed to be executed between builds with invoker " + invoker);
        }
    }

    @Override
    public void beforeBuild(BuildContext context) {
        if (this.schedule == CleanupSchedule.BUILD) {
            this.cleanup();
        }
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        if (this.schedule == CleanupSchedule.SCENARIO) {
            this.cleanup();
        }
    }

    @Override
    public void beforeCleanup(BuildContext context) {
        if (this.schedule == CleanupSchedule.CLEANUP) {
            this.cleanup();
        }
    }

    protected abstract void cleanup();

    protected static void delete(File f) {
        try {
            if (f.isFile()) {
                Files.delete(f.toPath());
            } else {
                FileUtils.deleteDirectory((File)f);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not delete " + f, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.schedule) + ")";
    }

    public static enum CleanupSchedule {
        SCENARIO,
        CLEANUP,
        BUILD;

    }

    protected static abstract class Configurator
    implements BuildMutatorConfigurator {
        protected Configurator() {
        }

        @Override
        public BuildMutator configure(Config scenario, String scenarioName, InvocationSettings settings, String key) {
            CleanupSchedule schedule = ConfigUtil.enumValue(scenario, key, CleanupSchedule.class, null);
            if (schedule == null) {
                throw new IllegalArgumentException("Schedule for cleanup is not specified");
            }
            return this.newInstance(scenario, scenarioName, settings, key, schedule);
        }

        protected abstract BuildMutator newInstance(Config var1, String var2, InvocationSettings var3, String var4, CleanupSchedule var5);
    }
}

