/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;

public class ApplyChangeToNativeSourceFileMutator
extends AbstractFileChangeMutator {
    private static final ImmutableSet<String> nativeSourcecodeFileEndings = ImmutableSet.of((Object)"c", (Object)"cc", (Object)"cp", (Object)"cxx", (Object)"cpp", (Object)"c++", (Object[])new String[0]);
    private static final ImmutableSet<String> nativeHeaderFileEndings = ImmutableSet.of((Object)"h", (Object)"hh", (Object)"hp", (Object)"hxx", (Object)"hpp", (Object)"h++", (Object[])new String[]{"tcc"});

    public ApplyChangeToNativeSourceFileMutator(File file) {
        super(file);
        boolean isSupportedExtension;
        String fileExtension = this.getSourceFileExtension();
        boolean bl = isSupportedExtension = nativeSourcecodeFileEndings.contains((Object)fileExtension) || nativeHeaderFileEndings.contains((Object)fileExtension);
        if (isSupportedExtension) {
            return;
        }
        throw new IllegalArgumentException("Can only modify C/C++ source or header files");
    }

    @Override
    protected void applyChangeTo(BuildContext context, StringBuilder text) {
        if (nativeSourcecodeFileEndings.contains((Object)this.getSourceFileExtension())) {
            int insertPos = text.length();
            this.applyChangeAt(context, text, insertPos);
        } else {
            int insertPos = text.lastIndexOf("#endif");
            if (insertPos < 0) {
                throw new IllegalArgumentException("Cannot parse header file " + this.sourceFile + " to apply changes");
            }
            this.applyHeaderChangeAt(context, text, insertPos);
        }
    }

    private String getSourceFileExtension() {
        return FilenameUtils.getExtension((String)this.sourceFile.getName()).toLowerCase(Locale.US);
    }

    protected String getFieldName(BuildContext context) {
        return "_m" + context.getUniqueBuildId();
    }

    private void applyChangeAt(BuildContext context, StringBuilder text, int insertPos) {
        text.insert(insertPos, "\nint " + this.getFieldName(context) + " () { }");
    }

    private void applyHeaderChangeAt(BuildContext context, StringBuilder text, int insertPos) {
        text.insert(insertPos, "int " + this.getFieldName(context) + "();\n");
    }
}

