/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class FileChangeMutatorConfigurator
implements BuildMutatorConfigurator {
    private final Class<? extends AbstractFileChangeMutator> mutatorClass;

    public FileChangeMutatorConfigurator(Class<? extends AbstractFileChangeMutator> mutatorClass) {
        this.mutatorClass = mutatorClass;
    }

    @Override
    public BuildMutator configure(Config scenario, String scenarioName, InvocationSettings settings, String key) {
        ArrayList<BuildMutator> mutatorsForKey = new ArrayList<BuildMutator>();
        for (File sourceFileToChange : FileChangeMutatorConfigurator.sourceFiles(scenario, scenarioName, settings.getProjectDir(), key)) {
            mutatorsForKey.add(this.getBuildMutatorForFile(sourceFileToChange));
        }
        return new CompositeBuildMutator(mutatorsForKey);
    }

    private BuildMutator getBuildMutatorForFile(File sourceFileToChange) {
        if (sourceFileToChange != null) {
            try {
                try {
                    return this.mutatorClass.getConstructor(File.class).newInstance(sourceFileToChange);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not create instance of mutator " + this.mutatorClass.getSimpleName(), e);
            }
        }
        return null;
    }

    private static List<File> sourceFiles(Config config, String scenarioName, File projectDir, String key) {
        return ConfigUtil.strings(config, key).stream().map(fileName -> FileChangeMutatorConfigurator.openFile(fileName, projectDir, scenarioName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static File openFile(String fileName, File projectDir, String scenarioName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(projectDir, fileName);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Source file " + file.getName() + " specified for scenario " + scenarioName + " does not exist.");
        }
        return file;
    }
}

