/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.profiler.instrument.GradleInstrumentation;
import org.gradle.profiler.studio.LaunchConfiguration;

public class LauncherConfigurationParser {
    public LaunchConfiguration calculate(Path studioInstallDir) {
        Path actualInstallDir;
        Dict entries = LauncherConfigurationParser.parse(studioInstallDir.resolve("Contents/Info.plist"));
        if ("jetbrains-toolbox-launcher".equals(entries.string("CFBundleExecutable"))) {
            actualInstallDir = Paths.get(entries.string("JetBrainsToolboxApp"), new String[0]);
            entries = LauncherConfigurationParser.parse(actualInstallDir.resolve("Contents/Info.plist"));
        } else {
            actualInstallDir = studioInstallDir;
        }
        Dict jvmOptions = entries.dict("JVMOptions");
        List<Path> classPath = Arrays.stream(jvmOptions.string("ClassPath").split(":")).map(s -> FileSystems.getDefault().getPath(s.replace("$APP_PACKAGE", actualInstallDir.toString()), new String[0])).collect(Collectors.toList());
        String mainClass = jvmOptions.string("MainClass");
        Map<String, String> systemProperties = LauncherConfigurationParser.mapValues(jvmOptions.dict("Properties").toMap(), v -> v.replace("$APP_PACKAGE", actualInstallDir.toString()));
        Path javaCommand = actualInstallDir.resolve("Contents/jre/jdk/Contents/Home/bin/java");
        Path agentJar = GradleInstrumentation.unpackPlugin("studio-agent").toPath();
        Path asmJar = GradleInstrumentation.unpackPlugin("asm").toPath();
        Path supportJar = GradleInstrumentation.unpackPlugin("instrumentation-support").toPath();
        Path protocolJar = GradleInstrumentation.unpackPlugin("client-protocol").toPath();
        return new LaunchConfiguration(javaCommand, classPath, systemProperties, mainClass, agentJar, supportJar, Arrays.asList(asmJar, protocolJar));
    }

    private static Dict parse(Path infoFile) {
        try {
            return new Dict((NSDictionary)PropertyListParser.parse((File)infoFile.toFile()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not parse '%s'.", infoFile), e);
        }
    }

    private static <T, S> Map<String, S> mapValues(Map<String, T> map, Function<T, S> mapper) {
        LinkedHashMap<String, S> result = new LinkedHashMap<String, S>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            result.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return result;
    }

    private static class Dict {
        private final NSDictionary contents;

        public Dict(NSDictionary contents) {
            this.contents = contents;
        }

        Dict dict(String key) {
            return new Dict((NSDictionary)this.getEntry(key));
        }

        String string(String key) {
            return ((NSString)this.getEntry(key)).getContent();
        }

        Map<String, String> toMap() {
            return LauncherConfigurationParser.mapValues((Map)this.contents, v -> ((NSString)v).getContent());
        }

        private NSObject getEntry(String key) {
            NSObject value = this.contents.get((Object)key);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Dictionary does not contain entry '%s'.", key));
            }
            return value;
        }
    }
}

