/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.report.BuildScenarioResult;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.Sample;

public class BuildScenarioResultImpl<T extends BuildInvocationResult>
implements BuildScenarioResult<T>,
Consumer<T> {
    private final ScenarioDefinition scenario;
    private final List<Sample<? super T>> samples;
    private final List<T> results = new ArrayList<T>();

    public BuildScenarioResultImpl(ScenarioDefinition scenario, List<Sample<? super T>> samples) {
        this.scenario = scenario;
        this.samples = ImmutableList.copyOf(samples);
    }

    @Override
    public void accept(T buildInvocationResult) {
        this.results.add(buildInvocationResult);
    }

    @Override
    public ScenarioDefinition getScenarioDefinition() {
        return this.scenario;
    }

    @Override
    public List<Sample<? super T>> getSamples() {
        return this.samples;
    }

    @Override
    public List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }
}

