/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.BuildUnderTestInvoker;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.DaemonControl;
import org.gradle.profiler.GradleArgsCalculator;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleBuildInvocationResult;
import org.gradle.profiler.GradleBuildInvoker;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.GradleScenarioDefinition;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.Logging;
import org.gradle.profiler.Phase;
import org.gradle.profiler.ProfilerController;
import org.gradle.profiler.RecordingBuildStepAction;
import org.gradle.profiler.RunCleanupStepAction;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.ScenarioInvoker;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.StopDaemonAfterAction;
import org.gradle.profiler.buildops.BuildOperationInstrumentation;
import org.gradle.profiler.instrument.PidInstrumentation;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.Sample;

public class GradleScenarioInvoker
extends ScenarioInvoker<GradleScenarioDefinition, GradleBuildInvocationResult> {
    private final DaemonControl daemonControl;
    private final PidInstrumentation pidInstrumentation;

    public GradleScenarioInvoker(DaemonControl daemonControl, PidInstrumentation pidInstrumentation) {
        this.daemonControl = daemonControl;
        this.pidInstrumentation = pidInstrumentation;
    }

    @Override
    public List<Sample<? super GradleBuildInvocationResult>> samplesFor(InvocationSettings settings, GradleScenarioDefinition scenario) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(BuildInvocationResult.EXECUTION_TIME);
        if (settings.isMeasureGarbageCollection()) {
            builder.add(GradleBuildInvocationResult.GARBAGE_COLLECTION_TIME);
        }
        if (settings.isMeasureConfigTime()) {
            builder.add(GradleBuildInvocationResult.TIME_TO_TASK_EXECUTION);
        }
        scenario.getMeasuredBuildOperations().stream().map(GradleBuildInvocationResult::sampleBuildOperation).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun(GradleScenarioDefinition scenario, InvocationSettings settings, Consumer<GradleBuildInvocationResult> resultConsumer) throws IOException, InterruptedException {
        if (settings.isProfile() && scenario.getWarmUpCount() == 0) {
            throw new IllegalStateException("Using the --profile option requires at least one warm-up");
        }
        ScenarioSettings scenarioSettings = new ScenarioSettings(settings, scenario);
        FileUtils.forceMkdir((File)scenario.getOutputDir());
        JvmArgsCalculator allBuildsJvmArgsCalculator = settings.getProfiler().newJvmArgsCalculator(scenarioSettings);
        GradleArgsCalculator allBuildsGradleArgsCalculator = this.pidInstrumentation;
        allBuildsGradleArgsCalculator = allBuildsGradleArgsCalculator.plus(settings.getProfiler().newGradleArgsCalculator(scenarioSettings));
        BuildOperationInstrumentation buildOperationInstrumentation = new BuildOperationInstrumentation(settings.isMeasureGarbageCollection(), settings.isMeasureConfigTime(), scenario.getMeasuredBuildOperations());
        if (buildOperationInstrumentation.requiresInitScript()) {
            allBuildsGradleArgsCalculator = allBuildsGradleArgsCalculator.plus(buildOperationInstrumentation);
        }
        GradleBuildConfiguration buildConfiguration = scenario.getBuildConfiguration();
        this.daemonControl.stop(buildConfiguration);
        CompositeBuildMutator mutator = new CompositeBuildMutator(scenario.getBuildMutators());
        ScenarioContext scenarioContext = ScenarioContext.from(settings, scenario);
        GradleClient gradleClient = scenario.getInvoker().getClient().create(buildConfiguration, settings);
        try {
            buildConfiguration.printVersionInfo();
            ArrayList<String> allBuildsJvmArgs = new ArrayList<String>(buildConfiguration.getJvmArguments());
            allBuildsJvmArgs.addAll(scenario.getJvmArgs());
            for (Map.Entry<String, String> entry : scenario.getSystemProperties().entrySet()) {
                allBuildsJvmArgs.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
            allBuildsJvmArgs.add("-Dorg.gradle.profiler.scenario=" + scenario.getName());
            allBuildsJvmArgsCalculator.calculateJvmArgs(allBuildsJvmArgs);
            this.logJvmArgs(allBuildsJvmArgs);
            ArrayList<String> allBuildsGradleArgs = new ArrayList<String>();
            allBuildsGradleArgs.add("--gradle-user-home");
            allBuildsGradleArgs.add(settings.getGradleUserHome().getAbsolutePath());
            for (Map.Entry<String, String> entry : scenario.getSystemProperties().entrySet()) {
                allBuildsGradleArgs.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
            allBuildsGradleArgs.addAll(scenario.getGradleArgs());
            if (settings.isDryRun()) {
                allBuildsGradleArgs.add("--dry-run");
            }
            allBuildsGradleArgsCalculator.calculateGradleArgs(allBuildsGradleArgs);
            this.logGradleArgs(allBuildsGradleArgs);
            BuildUnderTestInvoker buildUnderTestInvoker = new BuildUnderTestInvoker(allBuildsJvmArgs, allBuildsGradleArgs, gradleClient, this.pidInstrumentation, buildOperationInstrumentation);
            BuildStepAction<?> buildStepAction = this.cleanupStep(buildUnderTestInvoker, mutator, scenario, buildConfiguration);
            BuildStepAction<GradleBuildInvocationResult> warmupBuildStep = this.buildStep(buildUnderTestInvoker, scenario);
            mutator.beforeScenario(scenarioContext);
            GradleBuildInvocationResult results = null;
            String pid = null;
            for (int iteration = 1; iteration <= scenario.getWarmUpCount(); ++iteration) {
                BuildContext buildContext = scenarioContext.withBuild(Phase.WARM_UP, iteration);
                buildStepAction.run(buildContext, BuildStep.CLEANUP);
                results = this.runMeasured(buildContext, mutator, warmupBuildStep, resultConsumer);
                if (pid == null) {
                    pid = results.getDaemonPid();
                    continue;
                }
                GradleScenarioInvoker.checkPid(pid, results.getDaemonPid(), scenario.getInvoker());
            }
            ProfilerController control = settings.getProfiler().newController(pid, scenarioSettings);
            ArrayList<String> instrumentedBuildJvmArgs = new ArrayList<String>(allBuildsJvmArgs);
            settings.getProfiler().newInstrumentedBuildsJvmArgsCalculator(scenarioSettings).calculateJvmArgs(instrumentedBuildJvmArgs);
            ArrayList<String> instrumentedBuildGradleArgs = new ArrayList<String>(allBuildsGradleArgs);
            settings.getProfiler().newInstrumentedBuildsGradleArgsCalculator(scenarioSettings).calculateGradleArgs(instrumentedBuildGradleArgs);
            Logging.detailed().println();
            Logging.detailed().println("* Using args for instrumented builds:");
            if (!instrumentedBuildJvmArgs.equals(allBuildsJvmArgs)) {
                this.logJvmArgs(instrumentedBuildJvmArgs);
            }
            if (!instrumentedBuildGradleArgs.equals(allBuildsGradleArgs)) {
                this.logGradleArgs(instrumentedBuildGradleArgs);
            }
            BuildUnderTestInvoker instrumentedBuildInvoker = buildUnderTestInvoker.withJvmArgs(instrumentedBuildJvmArgs).withGradleArgs(instrumentedBuildGradleArgs);
            BuildStepAction<GradleBuildInvocationResult> measuredBuildStep = this.buildStep(instrumentedBuildInvoker, scenario);
            RecordingBuildStepAction recordingBuildStep = new RecordingBuildStepAction(measuredBuildStep, buildStepAction, scenario, control);
            control.startSession();
            for (int i = 1; i <= scenario.getBuildCount(); ++i) {
                BuildContext buildContext = scenarioContext.withBuild(Phase.MEASURE, i);
                buildStepAction.run(buildContext, BuildStep.CLEANUP);
                results = this.runMeasured(buildContext, mutator, recordingBuildStep, resultConsumer);
            }
            control.stopSession();
            Objects.requireNonNull(results);
            GradleScenarioInvoker.checkPid(pid, results.getDaemonPid(), scenario.getInvoker());
        }
        finally {
            mutator.afterScenario(scenarioContext);
            gradleClient.close();
            this.daemonControl.stop(buildConfiguration);
        }
    }

    private BuildStepAction<GradleBuildInvocationResult> buildStep(BuildUnderTestInvoker invoker, GradleScenarioDefinition scenario) {
        return invoker.create(scenario.getAction());
    }

    private BuildStepAction<?> cleanupStep(BuildUnderTestInvoker invoker, BuildMutator buildMutator, GradleScenarioDefinition scenario, GradleBuildConfiguration buildConfiguration) {
        BuildStepAction<GradleBuildInvocationResult> cleanupStep = invoker.create(scenario.getCleanupAction());
        if (scenario.getInvoker().isShouldCleanUpDaemon()) {
            cleanupStep = new StopDaemonAfterAction<GradleBuildInvocationResult>(cleanupStep, this.daemonControl, buildConfiguration);
        }
        return new RunCleanupStepAction<GradleBuildInvocationResult>(cleanupStep, buildMutator);
    }

    private void logGradleArgs(List<String> allBuildsGradleArgs) {
        Logging.detailed().println("Gradle args:");
        for (String arg : allBuildsGradleArgs) {
            Logging.detailed().println("  " + arg);
        }
    }

    private void logJvmArgs(List<String> allBuildsJvmArgs) {
        Logging.detailed().println("JVM args:");
        for (String jvmArg : allBuildsJvmArgs) {
            Logging.detailed().println("  " + jvmArg);
        }
    }

    private static void checkPid(String expected, String actual, GradleBuildInvoker invoker) {
        if (invoker.isReuseDaemon()) {
            if (!expected.equals(actual)) {
                throw new RuntimeException("Multiple Gradle daemons were used.");
            }
        } else if (expected.equals(actual)) {
            throw new RuntimeException("Gradle daemon was reused but should not be reused.");
        }
    }
}

