/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.instrument;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.profiler.GeneratedInitScript;
import org.gradle.profiler.GradleArgsCalculator;

public abstract class GradleInstrumentation
implements GradleArgsCalculator {
    private GeneratedInitScript initScript;

    protected abstract void generateInitScriptBody(PrintWriter var1);

    @Override
    public void calculateGradleArgs(List<String> gradleArgs) {
        this.maybeGenerate();
        this.initScript.calculateGradleArgs(gradleArgs);
    }

    private void maybeGenerate() {
        final File buildOpJar = GradleInstrumentation.unpackPlugin("build-operations");
        final File chromeTraceJar = GradleInstrumentation.unpackPlugin("chrome-trace");
        final File heapDumpJar = GradleInstrumentation.unpackPlugin("heap-dump");
        this.initScript = new GeneratedInitScript(){

            @Override
            public void writeContents(PrintWriter writer) {
                writer.write("initscript {\n");
                writer.write("    dependencies {\n");
                writer.write("        classpath files('" + buildOpJar.toURI() + "', '" + chromeTraceJar.toURI() + "', '" + heapDumpJar.toURI() + "')\n");
                writer.write("    }\n");
                writer.write("}\n");
                writer.write("\n");
                GradleInstrumentation.this.generateInitScriptBody(writer);
            }
        };
    }

    public static File unpackPlugin(String jarName) {
        try {
            File pluginJar = File.createTempFile(jarName, "jar").getCanonicalFile();
            try (InputStream inputStream = GradleInstrumentation.class.getResourceAsStream("/META-INF/jars/" + jarName + ".jar");){
                Files.copy(inputStream, pluginJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            pluginJar.deleteOnExit();
            return pluginJar;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

