/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.instrument;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.profiler.instrument.GradleInstrumentation;

public class PidInstrumentation
extends GradleInstrumentation {
    private final File pidFile = File.createTempFile("gradle-profiler", "pid");

    public PidInstrumentation() throws IOException {
        this.pidFile.deleteOnExit();
    }

    @Override
    protected void generateInitScriptBody(PrintWriter writer) {
        writer.println("org.gradle.trace.pid.PidCollector.collect(gradle, new File(new URI('" + this.pidFile.toURI() + "')))");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPidForLastBuild() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.pidFile));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read daemon PID from file.", e);
        }
    }
}

