/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.ScenarioContext;

public abstract class AbstractFileChangeMutator
implements BuildMutator {
    protected final File sourceFile;
    private final String originalText;

    protected AbstractFileChangeMutator(File sourceFile) {
        this.sourceFile = sourceFile;
        try {
            this.originalText = new String(Files.readAllBytes(sourceFile.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read contents of source file " + sourceFile, e);
        }
    }

    @Override
    public void beforeBuild(BuildContext context) {
        StringBuilder modifiedText = new StringBuilder(this.originalText);
        this.applyChangeTo(context, modifiedText);
        try {
            Files.write(this.sourceFile.toPath(), modifiedText.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void applyChangeTo(BuildContext var1, StringBuilder var2);

    private void revert() {
        try {
            Files.write(this.sourceFile.toPath(), this.originalText.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterScenario(ScenarioContext context) {
        this.revert();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.sourceFile + ')';
    }
}

