/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractCleanupMutator;

public class ClearConfigurationCacheStateMutator
extends AbstractCleanupMutator {
    private final File projectDir;

    public ClearConfigurationCacheStateMutator(File projectDir, AbstractCleanupMutator.CleanupSchedule schedule) {
        super(schedule);
        this.projectDir = projectDir;
    }

    @Override
    public void validate(BuildInvoker invoker) {
    }

    @Override
    protected void cleanup() {
        System.out.println("> Cleaning configuration cache state");
        this.cleanup(new File(this.projectDir, ".gradle/configuration-cache"));
        this.cleanup(new File(this.projectDir, ".instant-execution-state"));
    }

    private void cleanup(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractCleanupMutator.Configurator {
        @Override
        protected BuildMutator newInstance(Config scenario, String scenarioName, InvocationSettings settings, String key, AbstractCleanupMutator.CleanupSchedule schedule) {
            return new ClearConfigurationCacheStateMutator(settings.getProjectDir(), schedule);
        }
    }
}

