/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.AbstractGitMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class GitRevertMutator
extends AbstractGitMutator {
    private final List<String> commits;

    public GitRevertMutator(File projectDir, List<String> commits) {
        super(projectDir);
        this.commits = commits;
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        this.resetGit();
    }

    @Override
    public void beforeBuild(BuildContext context) {
        this.revertCommits();
    }

    @Override
    public void afterBuild(BuildContext context, Throwable error) {
        if (error == null) {
            this.abortRevert();
            this.resetGit();
        } else {
            System.out.println("> Not resetting Git because of error during build");
        }
    }

    private void revertCommits() {
        System.out.println("> Reverting Git commit(s) " + this.commits.stream().collect(Collectors.joining(", ")));
        new CommandExec().inDir(this.projectDir).run("git", "revert", "--quit");
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(Arrays.asList("git", "revert", "--no-commit"));
        commandLine.addAll(this.commits);
        new CommandExec().inDir(this.projectDir).run(commandLine);
    }

    private void abortRevert() {
        System.out.println("> Aborting revert");
        new CommandExec().inDir(this.projectDir).run("git", "revert", "--abort");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.commits.stream().collect(Collectors.joining(", ")) + ")";
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        @Override
        public BuildMutator configure(Config scenario, String scenarioName, InvocationSettings settings, String key) {
            List<String> commits = ConfigUtil.strings(scenario, key);
            if (commits.isEmpty()) {
                throw new IllegalArgumentException("No commits specified for git-revert");
            }
            return new GitRevertMutator(settings.getProjectDir(), commits);
        }
    }
}

