/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Logging;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.client.protocol.ConnectionParameters;
import org.gradle.profiler.client.protocol.Server;
import org.gradle.profiler.client.protocol.ServerConnection;
import org.gradle.profiler.client.protocol.SyncCompleted;
import org.gradle.profiler.client.protocol.SyncParameters;
import org.gradle.profiler.client.protocol.SyncStarted;
import org.gradle.profiler.studio.LaunchConfiguration;
import org.gradle.profiler.studio.LauncherConfigurationParser;

public class StudioGradleClient
implements GradleClient {
    private final Server server;
    private final CommandExec.RunHandle studioProcess;
    private final ServerConnection agentConnection;
    private boolean hasRun;

    public StudioGradleClient(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
        if (!OperatingSystem.isMacOS()) {
            throw new IllegalArgumentException("Support for Android studio is currently only implemented on macOS.");
        }
        Path studioInstallDir = invocationSettings.getStudioInstallDir().toPath();
        Logging.startOperation("Starting Android Studio at " + studioInstallDir);
        LaunchConfiguration launchConfiguration = new LauncherConfigurationParser().calculate(studioInstallDir);
        System.out.println();
        System.out.println("* Java command: " + launchConfiguration.getJavaCommand());
        System.out.println("* Classpath:");
        for (Path path : launchConfiguration.getClassPath()) {
            System.out.println("  " + path);
        }
        System.out.println("* System properties:");
        for (Map.Entry entry : launchConfiguration.getSystemProperties().entrySet()) {
            System.out.println("  " + (String)entry.getKey() + " -> " + (String)entry.getValue());
        }
        System.out.println("* Main class: " + launchConfiguration.getMainClass());
        this.server = new Server("agent");
        this.studioProcess = this.startStudio(launchConfiguration, studioInstallDir, invocationSettings, this.server);
        this.agentConnection = this.server.waitForIncoming(Duration.ofMinutes(1L));
        this.agentConnection.send(new ConnectionParameters(buildConfiguration.getGradleHome()));
    }

    private CommandExec.RunHandle startStudio(LaunchConfiguration launchConfiguration, Path studioInstallDir, InvocationSettings invocationSettings, Server server) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(launchConfiguration.getJavaCommand().toString());
        commandLine.add("-cp");
        commandLine.add(Joiner.on((String)File.pathSeparator).join(launchConfiguration.getClassPath()));
        for (Map.Entry<String, String> systemProperty : launchConfiguration.getSystemProperties().entrySet()) {
            commandLine.add("-D" + systemProperty.getKey() + "=" + systemProperty.getValue());
        }
        commandLine.add("-javaagent:" + launchConfiguration.getAgentJar() + "=" + server.getPort() + "," + launchConfiguration.getSupportJar());
        commandLine.add("--add-exports");
        commandLine.add("java.base/jdk.internal.misc=ALL-UNNAMED");
        commandLine.add("-Xbootclasspath/a:" + Joiner.on((String)File.pathSeparator).join(launchConfiguration.getSharedJars()));
        commandLine.add(launchConfiguration.getMainClass());
        commandLine.add(invocationSettings.getProjectDir().getAbsolutePath());
        System.out.println("* Using command line: " + commandLine);
        return new CommandExec().inDir(studioInstallDir.toFile()).start(commandLine);
    }

    @Override
    public void close() throws IOException {
        System.out.println("* PLEASE STOP ANDROID STUDIO....");
        this.studioProcess.waitForSuccess();
        System.out.println("* Android Studio stopped.");
        this.server.close();
    }

    public Duration sync(List<String> gradleArgs, List<String> jvmArgs) {
        if (!this.hasRun) {
            System.out.println("* PLEASE RUN SYNC IN ANDROID STUDIO (once it has finished starting up)....");
            this.hasRun = true;
        } else {
            System.out.println("* PLEASE RUN SYNC IN ANDROID STUDIO....");
        }
        SyncStarted started = this.agentConnection.receiveSyncStarted(Duration.ofMinutes(10L));
        this.agentConnection.send(new SyncParameters(gradleArgs, jvmArgs));
        System.out.println("* Sync has started, waiting for it to complete...");
        SyncCompleted completed = this.agentConnection.receiveSyncCompeted(Duration.ofHours(1L));
        System.out.println("* Sync has completed");
        return Duration.ofMillis(completed.getDurationMillis());
    }
}

