/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.yourkit;

import java.io.File;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.yourkit.YourKit;
import org.gradle.profiler.yourkit.YourKitConfig;

public class YourKitProfilerController
implements InstrumentingProfiler.SnapshotCapturingProfilerController {
    private final YourKitConfig options;

    public YourKitProfilerController(YourKitConfig options) {
        this.options = options;
    }

    @Override
    public void startRecording(String pid) {
        if (this.options.isMemorySnapshot()) {
            this.runYourKitCommand("start-alloc-recording-adaptive");
        } else if (this.options.isUseSampling()) {
            this.runYourKitCommand("start-cpu-sampling");
        } else {
            this.runYourKitCommand("start-cpu-tracing");
        }
    }

    @Override
    public void stopRecording(String pid) {
        if (this.options.isMemorySnapshot()) {
            this.runYourKitCommand("stop-alloc-recording");
        } else {
            this.runYourKitCommand("stop-cpu-profiling");
        }
    }

    @Override
    public void captureSnapshot(String pid) {
        if (this.options.isMemorySnapshot()) {
            this.runYourKitCommand("capture-memory-snapshot");
        } else {
            this.runYourKitCommand("capture-performance-snapshot");
        }
    }

    @Override
    public void stopSession() {
    }

    private void runYourKitCommand(String command) {
        File controllerJar = this.findControllerJar();
        new CommandExec().run(System.getProperty("java.home") + "/bin/java", "-jar", controllerJar.getAbsolutePath(), "localhost", String.valueOf(10021), command);
    }

    private File findControllerJar() {
        File yourKitHome = YourKit.findYourKitHome();
        File controllerJar = YourKit.findControllerJar();
        if (!controllerJar.isFile()) {
            throw new IllegalArgumentException("Could not locate YourKit library in YourKit home directory " + yourKitHome);
        }
        return controllerJar;
    }
}

