/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.profiler.BuckScenarioDefinition;
import org.gradle.profiler.BuildToolCommandLineInvoker;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Logging;
import org.gradle.profiler.result.BuildInvocationResult;

public class BuckScenarioInvoker
extends BuildToolCommandLineInvoker<BuckScenarioDefinition, BuildInvocationResult> {
    @Override
    public void run(BuckScenarioDefinition scenario, InvocationSettings settings, Consumer<BuildInvocationResult> resultConsumer) {
        ArrayList<String> commandLine;
        String buckwExe = settings.getProjectDir() + "/buckw";
        ArrayList<String> targets = new ArrayList<String>(scenario.getTargets());
        if (scenario.getType() != null) {
            Logging.startOperation("Query targets with type " + scenario.getType());
            commandLine = new ArrayList<String>();
            commandLine.add(buckwExe);
            commandLine.add("targets");
            if (!scenario.getType().equals("all")) {
                commandLine.add("--type");
                commandLine.add(scenario.getType());
            }
            String output = new CommandExec().inDir(settings.getProjectDir()).runAndCollectOutput(commandLine);
            targets.addAll(Arrays.stream(output.split("\\n")).filter(s -> s.matches("//\\w+.*")).collect(Collectors.toList()));
        }
        Logging.detailed().println("* Buck targets: " + targets);
        commandLine = new ArrayList();
        commandLine.add(buckwExe);
        commandLine.add("build");
        commandLine.addAll(targets);
        this.doRun(scenario, settings, resultConsumer, commandLine);
    }
}

