/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.Logging;
import org.gradle.profiler.OperatingSystem;
import org.gradle.util.GradleVersion;

public class GradleBuildConfiguration {
    private final GradleVersion gradleVersion;
    private final File gradleHome;
    private final File javaHome;
    private final List<String> jvmArguments;
    private final boolean usesScanPlugin;
    private final List<String> clientJvmArguments;

    public GradleBuildConfiguration(GradleVersion gradleVersion, File gradleHome, File javaHome, List<String> jvmArguments, boolean usesScanPlugin) {
        this(gradleVersion, gradleHome, javaHome, jvmArguments, usesScanPlugin, Collections.emptyList());
    }

    public GradleBuildConfiguration(GradleVersion gradleVersion, File gradleHome, File javaHome, List<String> jvmArguments, boolean usesScanPlugin, List<String> gradleOpts) {
        this.gradleVersion = gradleVersion;
        this.gradleHome = gradleHome;
        this.javaHome = javaHome;
        this.usesScanPlugin = usesScanPlugin;
        this.jvmArguments = jvmArguments;
        this.clientJvmArguments = gradleOpts;
    }

    public GradleVersion getGradleVersion() {
        return this.gradleVersion;
    }

    public File getGradleHome() {
        return this.gradleHome;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public boolean isUsesScanPlugin() {
        return this.usesScanPlugin;
    }

    public List<String> getClientJvmArguments() {
        return this.clientJvmArguments;
    }

    public void printVersionInfo() {
        Logging.detailed().println();
        Logging.detailed().println("* Build details");
        Logging.detailed().println("Gradle version: " + this.gradleVersion);
        Logging.detailed().println("Java home: " + this.javaHome);
        Logging.detailed().println("OS: " + OperatingSystem.getId());
    }

    public void runGradle(String ... arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        this.addGradleCommand(commandLine);
        commandLine.addAll(Arrays.asList(arguments));
        new CommandExec().run(commandLine);
    }

    public void addGradleCommand(List<String> commandLine) {
        String gradleScriptName = OperatingSystem.isWindows() ? "gradle.bat" : "gradle";
        commandLine.add(new File(this.gradleHome, "bin/" + gradleScriptName).getAbsolutePath());
    }
}

