/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.gradle.profiler.CommandExec;

public class FlameGraphTool {
    private final File flamegraphScript;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File createScript(String scriptName) {
        try (InputStream stream = FlameGraphTool.class.getResource(scriptName + ".pl").openStream();){
            File script = File.createTempFile(scriptName, ".pl");
            Files.copy(stream, script.toPath(), StandardCopyOption.REPLACE_EXISTING);
            script.deleteOnExit();
            script.setExecutable(true);
            File file = script;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FlameGraphTool() {
        this.flamegraphScript = FlameGraphTool.createScript("flamegraph");
    }

    public FlameGraphTool(File flamegraphHome) {
        this.flamegraphScript = new File(flamegraphHome, "flamegraph.pl");
    }

    public boolean checkInstallation() {
        try {
            new CommandExec().runAndCollectOutput("perl", "-v");
            return true;
        }
        catch (Exception e) {
            System.out.println("To get flamegraphs, please install perl.");
            return false;
        }
    }

    public void generateFlameGraph(File stacks, File flames, List<String> args) {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add("perl");
        allArgs.add(this.flamegraphScript.getAbsolutePath());
        allArgs.add(stacks.getAbsolutePath());
        allArgs.addAll(args);
        new CommandExec().runAndCollectOutput(flames, allArgs);
    }
}

