/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractFileChangeMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;
import org.gradle.profiler.mutations.support.ScenarioSupport;

public class FileChangeMutatorConfigurator
implements BuildMutatorConfigurator {
    private final Class<? extends AbstractFileChangeMutator> mutatorClass;

    public FileChangeMutatorConfigurator(Class<? extends AbstractFileChangeMutator> mutatorClass) {
        this.mutatorClass = mutatorClass;
    }

    @Override
    public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
        ArrayList<BuildMutator> mutatorsForKey = new ArrayList<BuildMutator>();
        InvocationSettings settings = spec.getInvocationSettings();
        for (File sourceFileToChange : ScenarioSupport.sourceFiles(spec.getScenario(), spec.getScenarioName(), settings.getProjectDir(), key)) {
            mutatorsForKey.add(this.getBuildMutatorForFile(sourceFileToChange));
        }
        return new CompositeBuildMutator(mutatorsForKey);
    }

    private BuildMutator getBuildMutatorForFile(File sourceFileToChange) {
        if (sourceFileToChange == null) {
            return null;
        }
        try {
            return this.mutatorClass.getConstructor(File.class).newInstance(sourceFileToChange);
        }
        catch (Throwable e) {
            Throwable throwable = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new RuntimeException("Could not create instance of mutator " + this.mutatorClass.getSimpleName(), throwable);
        }
    }
}

