/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gradle.profiler.ArgumentsSplitter;
import org.gradle.profiler.DaemonControl;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleBuildConfigurationReader;
import org.gradle.profiler.Logging;
import org.gradle.profiler.ToolingApiGradleClient;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.JavaEnvironment;
import org.gradle.util.GradleVersion;

public class DefaultGradleBuildConfigurationReader
implements GradleBuildConfigurationReader {
    private final File projectDir;
    private final File gradleUserHome;
    private final DaemonControl daemonControl;
    private final File initScript;
    private final File buildDetails;
    private final Map<String, GradleBuildConfiguration> versions = new HashMap<String, GradleBuildConfiguration>();
    private GradleBuildConfiguration defaultVersion;

    public DefaultGradleBuildConfigurationReader(File projectDir, File gradleUserHome, DaemonControl daemonControl) throws IOException {
        this.projectDir = projectDir;
        this.gradleUserHome = gradleUserHome;
        this.daemonControl = daemonControl;
        this.initScript = File.createTempFile("gradle-profiler", ".gradle").getCanonicalFile();
        this.initScript.deleteOnExit();
        this.buildDetails = File.createTempFile("gradle-profiler", "build-details");
        this.buildDetails.deleteOnExit();
        this.generateInitScript();
    }

    private void generateInitScript() throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.initScript));){
            writer.println("rootProject {\n  afterEvaluate {\n    def detailsFile = new File(new URI('" + this.buildDetails.toURI() + "'))\n    detailsFile.text = \"${gradle.gradleHomeDir}\\n\"\n    detailsFile << plugins.hasPlugin('com.gradle.build-scan') << '\\n'\n  }\n}\n");
        }
    }

    @Override
    public GradleBuildConfiguration readConfiguration(String gradleVersion) {
        GradleBuildConfiguration version = this.versions.get(gradleVersion);
        if (version == null) {
            version = this.doResolveVersion(gradleVersion);
            this.versions.put(gradleVersion, version);
        }
        return version;
    }

    private GradleBuildConfiguration doResolveVersion(String versionString) {
        Logging.startOperation("Inspecting the build using Gradle version '" + versionString + "'");
        try {
            File dir = new File(versionString);
            if (dir.isDirectory()) {
                dir = dir.getCanonicalFile();
                return this.probe(this.connector().useInstallation(dir));
            }
            if (versionString.matches("\\d+(\\.\\d+)+(-.+)?")) {
                return this.probe(this.connector().useGradleVersion(versionString));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not locate Gradle distribution for requested version '" + versionString + "'.", e);
        }
        throw new IllegalArgumentException("Unrecognized Gradle version '" + versionString + "' specified.");
    }

    @Override
    public GradleBuildConfiguration readConfiguration() {
        if (this.defaultVersion == null) {
            Logging.startOperation("Inspecting the build using its default Gradle version");
            this.defaultVersion = this.probe(this.connector());
        }
        return this.defaultVersion;
    }

    private GradleConnector connector() {
        return GradleConnector.newConnector().useGradleUserHomeDir(this.gradleUserHome.getAbsoluteFile());
    }

    private List<String> readBuildDetails() {
        try {
            return Files.readAllLines(this.buildDetails.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the build's configuration.", e);
        }
    }

    private GradleBuildConfiguration probe(GradleConnector connector) {
        GradleBuildConfiguration version;
        try (ProjectConnection connection = connector.forProjectDirectory(this.projectDir).connect();){
            BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
            new ToolingApiGradleClient(connection).runTasks((List<String>)ImmutableList.of((Object)"help"), (List<String>)ImmutableList.of((Object)"-I", (Object)this.initScript.getAbsolutePath()), (List<String>)ImmutableList.of());
            List<String> buildDetails = this.readBuildDetails();
            JavaEnvironment javaEnvironment = buildEnvironment.getJava();
            ArrayList<String> allJvmArgs = new ArrayList<String>(javaEnvironment.getJvmArguments());
            allJvmArgs.addAll(this.readSystemPropertiesFromGradleProperties());
            version = new GradleBuildConfiguration(GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion()), new File(buildDetails.get(0)), javaEnvironment.getJavaHome(), allJvmArgs, Boolean.valueOf(buildDetails.get(1)));
        }
        this.daemonControl.stop(version);
        return version;
    }

    private List<String> readSystemPropertiesFromGradleProperties() {
        String jvmArgs = this.getJvmArgsProperty(this.gradleUserHome);
        if (jvmArgs == null) {
            jvmArgs = this.getJvmArgsProperty(this.projectDir);
        }
        if (jvmArgs == null) {
            return Collections.emptyList();
        }
        return ArgumentsSplitter.split(jvmArgs).stream().filter(arg -> arg.startsWith("-D")).collect(Collectors.toList());
    }

    private String getJvmArgsProperty(File scope) {
        File propertyFile = new File(scope, "gradle.properties");
        if (!propertyFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(propertyFile);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties from '" + propertyFile + "'.", e);
        }
        return properties.getProperty("org.gradle.jvmargs");
    }
}

