/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.BuildToolCommandLineScenarioDefinition;
import org.gradle.profiler.OperatingSystem;

public class BuckScenarioDefinition
extends BuildToolCommandLineScenarioDefinition {
    private final String type;

    public BuckScenarioDefinition(String scenarioName, @Nullable String title, List<String> targets, String type, List<BuildMutator> buildMutators, int warmUpCount, int buildCount, File outputDir, @Nullable File buckHome) {
        super(scenarioName, title, targets, buildMutators, warmUpCount, buildCount, outputDir, buckHome);
        this.type = type;
    }

    @Override
    public String getDisplayName() {
        return this.getTitle() + " using buck";
    }

    @Override
    public String getProfileName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBuildToolDisplayName() {
        return "buck";
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BuildInvoker getInvoker() {
        return BuildInvoker.Buck;
    }

    @Override
    protected void printDetail(PrintStream out) {
        out.println("  Targets: " + this.getTargets());
        if (this.getType() != null) {
            out.println("  Type: " + this.getType());
        }
    }

    @Override
    protected String getExecutableName() {
        if (OperatingSystem.isWindows()) {
            return "buck.exe";
        }
        return "buck";
    }

    @Override
    protected String getToolHomeEnvName() {
        return "BUCK_HOME";
    }
}

