/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.BuildToolCommandLineScenarioDefinition;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.Phase;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioInvoker;
import org.gradle.profiler.Timer;
import org.gradle.profiler.result.BuildInvocationResult;

public abstract class BuildToolCommandLineInvoker<T extends BuildToolCommandLineScenarioDefinition, R extends BuildInvocationResult>
extends ScenarioInvoker<T, R> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun(T scenario, InvocationSettings settings, Consumer<BuildInvocationResult> resultConsumer, List<String> commandLine) {
        ScenarioContext scenarioContext = ScenarioContext.from(settings, scenario);
        CompositeBuildMutator mutator = new CompositeBuildMutator(((ScenarioDefinition)scenario).getBuildMutators());
        mutator.beforeScenario(scenarioContext);
        try {
            BuildContext buildContext;
            int iteration;
            for (iteration = 1; iteration <= ((ScenarioDefinition)scenario).getWarmUpCount(); ++iteration) {
                buildContext = scenarioContext.withBuild(Phase.WARM_UP, iteration);
                this.runMeasured(buildContext, mutator, this.measureCommandLineExecution(commandLine, settings.getProjectDir(), settings.getBuildLog()), resultConsumer);
            }
            for (iteration = 1; iteration <= ((ScenarioDefinition)scenario).getBuildCount(); ++iteration) {
                buildContext = scenarioContext.withBuild(Phase.MEASURE, iteration);
                this.runMeasured(buildContext, mutator, this.measureCommandLineExecution(commandLine, settings.getProjectDir(), settings.getBuildLog()), resultConsumer);
            }
        }
        finally {
            mutator.afterScenario(scenarioContext);
        }
    }

    private BuildStepAction<R> measureCommandLineExecution(final List<String> commandLine, final File workingDir, final File buildLog) {
        return new BuildStepAction<R>(){

            @Override
            public boolean isDoesSomething() {
                return true;
            }

            @Override
            public R run(BuildContext buildContext, BuildStep buildStep) {
                Timer timer = new Timer();
                if (buildLog == null) {
                    new CommandExec().inDir(workingDir).run(commandLine);
                } else {
                    new CommandExec().inDir(workingDir).runAndCollectOutput(buildLog, commandLine);
                }
                Duration executionTime = timer.elapsed();
                return new BuildInvocationResult(buildContext, new BuildAction.BuildActionResult(executionTime));
            }
        };
    }
}

