/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.studio.launcher.StudioConfiguration;

public class StudioConfigurationProvider {
    public static StudioConfiguration getLaunchConfiguration(Path studioInstallDir) {
        if (OperatingSystem.isMacOS()) {
            return StudioConfigurationProvider.getMacOSConfiguration(studioInstallDir);
        }
        return StudioConfigurationProvider.getWindowsOrLinuxConfiguration(studioInstallDir);
    }

    private static StudioConfiguration getWindowsOrLinuxConfiguration(Path studioInstallDir) {
        String mainClass = "com.intellij.idea.Main";
        List<Path> classPath = Stream.of("lib/bootstrap.jar", "lib/util.jar", "lib/jdom.jar", "lib/log4j.jar", "lib/jna.jar").map(studioInstallDir::resolve).collect(Collectors.toList());
        Path javaCommand = studioInstallDir.resolve("jre/bin/java");
        ImmutableMap systemProperties = ImmutableMap.builder().put((Object)"idea.vendor.name", (Object)"Google").put((Object)"idea.executable", (Object)"studio").put((Object)"idea.platform.prefix", (Object)"AndroidStudio").build();
        return new StudioConfiguration(mainClass, studioInstallDir, javaCommand, classPath, (Map<String, String>)systemProperties);
    }

    private static StudioConfiguration getMacOSConfiguration(Path studioInstallDir) {
        Path actualInstallDir;
        Dict entries = StudioConfigurationProvider.parse(studioInstallDir.resolve("Contents/Info.plist"));
        if ("jetbrains-toolbox-launcher".equals(entries.string("CFBundleExecutable"))) {
            actualInstallDir = Paths.get(entries.string("JetBrainsToolboxApp"), new String[0]);
            entries = StudioConfigurationProvider.parse(actualInstallDir.resolve("Contents/Info.plist"));
        } else {
            actualInstallDir = studioInstallDir;
        }
        Dict jvmOptions = entries.dict("JVMOptions");
        List<Path> classPath = Arrays.stream(jvmOptions.string("ClassPath").split(":")).map(s -> FileSystems.getDefault().getPath(s.replace("$APP_PACKAGE", actualInstallDir.toString()), new String[0])).collect(Collectors.toList());
        Map<String, String> systemProperties = StudioConfigurationProvider.mapValues(jvmOptions.dict("Properties").toMap(), v -> v.replace("$APP_PACKAGE", actualInstallDir.toString()));
        String mainClass = jvmOptions.string("MainClass");
        Path javaCommand = actualInstallDir.resolve("Contents/jre/Contents/Home/bin/java");
        return new StudioConfiguration(mainClass, actualInstallDir, javaCommand, classPath, systemProperties);
    }

    private static Dict parse(Path infoFile) {
        try {
            return new Dict((NSDictionary)PropertyListParser.parse((File)infoFile.toFile()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not parse '%s'.", infoFile), e);
        }
    }

    private static <T, S> Map<String, S> mapValues(Map<String, T> map, Function<T, S> mapper) {
        LinkedHashMap<String, S> result = new LinkedHashMap<String, S>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            result.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return result;
    }

    private static class Dict {
        private final NSDictionary contents;

        public Dict(NSDictionary contents) {
            this.contents = contents;
        }

        Dict dict(String key) {
            return new Dict((NSDictionary)this.getEntry(key));
        }

        String string(String key) {
            return ((NSString)this.getEntry(key)).getContent();
        }

        Map<String, String> toMap() {
            return StudioConfigurationProvider.mapValues((Map)this.contents, v -> ((NSString)v).getContent());
        }

        private NSObject getEntry(String key) {
            NSObject value = this.contents.get((Object)key);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Dictionary does not contain entry '%s'.", key));
            }
            return value;
        }
    }
}

