/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.report.CsvGenerator;

public class InvocationSettings {
    private final File projectDir;
    private final Profiler profiler;
    private final boolean generateDiffs;
    private final boolean benchmark;
    private final boolean dryRun;
    private final File scenarioFile;
    private final File outputDir;
    private final BuildInvoker invoker;
    private final List<String> versions;
    private final List<String> targets;
    private final Map<String, String> sysProperties;
    private final File gradleUserHome;
    private final File studioInstallDir;
    private final File studioSandboxDir;
    private final Integer warmupCount;
    private final Integer iterations;
    private final boolean measureGarbageCollection;
    private final boolean measureConfigTime;
    private final List<String> measuredBuildOperations;
    private final CsvGenerator.Format csvFormat;
    private final String benchmarkTitle;
    private final File buildLog;
    private final UUID invocationId = UUID.randomUUID();

    private InvocationSettings(File projectDir, Profiler profiler, boolean generateDiffs, boolean benchmark, File outputDir, BuildInvoker invoker, boolean dryRun, File scenarioFile, List<String> versions, List<String> targets, Map<String, String> sysProperties, File gradleUserHome, @Nullable File studioInstallDir, File studioSandboxDir, Integer warmupCount, Integer iterations, boolean measureGarbageCollection, boolean measureConfigTime, List<String> measuredBuildOperations, CsvGenerator.Format csvFormat, String benchmarkTitle, File buildLog) {
        this.benchmark = benchmark;
        this.projectDir = projectDir;
        this.profiler = profiler;
        this.generateDiffs = generateDiffs;
        this.outputDir = outputDir;
        this.invoker = invoker;
        this.dryRun = dryRun;
        this.scenarioFile = scenarioFile;
        this.versions = versions;
        this.targets = targets;
        this.sysProperties = sysProperties;
        this.gradleUserHome = gradleUserHome;
        this.studioInstallDir = studioInstallDir;
        this.studioSandboxDir = studioSandboxDir;
        this.warmupCount = warmupCount;
        this.iterations = iterations;
        this.measureGarbageCollection = measureGarbageCollection;
        this.measureConfigTime = measureConfigTime;
        this.measuredBuildOperations = measuredBuildOperations;
        this.csvFormat = csvFormat;
        this.benchmarkTitle = benchmarkTitle;
        this.buildLog = buildLog;
    }

    @Nullable
    public File getBuildLog() {
        return this.buildLog;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public BuildInvoker getInvoker() {
        return this.invoker;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public boolean isProfile() {
        return this.profiler != Profiler.NONE;
    }

    public boolean isBazel() {
        return this.invoker == BuildInvoker.Bazel;
    }

    public boolean isBuck() {
        return this.invoker == BuildInvoker.Buck;
    }

    public boolean isMaven() {
        return this.invoker == BuildInvoker.Maven;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public boolean isGenerateDiffs() {
        return this.generateDiffs;
    }

    public File getScenarioFile() {
        return this.scenarioFile;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public Map<String, String> getSystemProperties() {
        return this.sysProperties;
    }

    public Integer getWarmUpCount() {
        return this.warmupCount;
    }

    public Integer getBuildCount() {
        return this.iterations;
    }

    public File getGradleUserHome() {
        return this.gradleUserHome;
    }

    public File getStudioInstallDir() {
        return this.studioInstallDir;
    }

    public Optional<File> getStudioSandboxDir() {
        return Optional.ofNullable(this.studioSandboxDir);
    }

    public boolean isMeasureGarbageCollection() {
        return this.measureGarbageCollection;
    }

    public boolean isMeasureConfigTime() {
        return this.measureConfigTime;
    }

    public List<String> getMeasuredBuildOperations() {
        return this.measuredBuildOperations;
    }

    public CsvGenerator.Format getCsvFormat() {
        return this.csvFormat;
    }

    public String getBenchmarkTitle() {
        return this.benchmarkTitle;
    }

    public UUID getInvocationId() {
        return this.invocationId;
    }

    public InvocationSettingsBuilder newBuilder() {
        return new InvocationSettingsBuilder().setProjectDir(this.projectDir).setProfiler(this.profiler).setGenerateDiffs(this.generateDiffs).setBenchmark(this.benchmark).setDryRun(this.dryRun).setScenarioFile(this.scenarioFile).setOutputDir(this.outputDir).setInvoker(this.invoker).setVersions(this.versions).setTargets(this.targets).setSysProperties(this.sysProperties).setGradleUserHome(this.gradleUserHome).setStudioInstallDir(this.studioInstallDir).setWarmupCount(this.warmupCount).setIterations(this.iterations).setMeasureGarbageCollection(this.measureGarbageCollection).setMeasureConfigTime(this.measureConfigTime).setMeasuredBuildOperations(this.measuredBuildOperations).setCsvFormat(this.csvFormat).setBenchmarkTitle(this.benchmarkTitle).setBuildLog(this.buildLog);
    }

    public void printTo(PrintStream out) {
        if (this.benchmarkTitle != null) {
            out.println("Title: " + this.benchmarkTitle);
        }
        out.println("Project dir: " + this.getProjectDir());
        out.println("Output dir: " + this.getOutputDir());
        out.println("Profiler: " + this.getProfiler());
        out.println("Benchmark: " + this.isBenchmark());
        out.println("Versions: " + this.getVersions());
        out.println("Gradle User Home: " + this.getGradleUserHome());
        out.println("Targets: " + this.getTargets());
        if (this.warmupCount != null) {
            out.println("Warm-ups: " + this.warmupCount);
        }
        if (this.iterations != null) {
            out.println("Builds: " + this.iterations);
        }
        if (!this.getSystemProperties().isEmpty()) {
            out.println("System properties:");
            for (Map.Entry<String, String> entry : this.getSystemProperties().entrySet()) {
                out.println("  " + entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    public static final class InvocationSettingsBuilder {
        private File projectDir;
        private Profiler profiler;
        private boolean generateDiffs;
        private boolean benchmark;
        private boolean dryRun;
        private File scenarioFile;
        private File outputDir;
        private BuildInvoker invoker;
        private List<String> versions;
        private List<String> targets;
        private Map<String, String> sysProperties;
        private File gradleUserHome;
        private File studioInstallDir;
        private File studioSandboxDir;
        private Integer warmupCount;
        private Integer iterations;
        private boolean measureGarbageCollection;
        private boolean measureConfigTime;
        private List<String> measuredBuildOperations;
        private CsvGenerator.Format csvFormat;
        private String benchmarkTitle;
        private File buildLog;

        public InvocationSettingsBuilder setProjectDir(File projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        public InvocationSettingsBuilder setProfiler(Profiler profiler) {
            this.profiler = profiler;
            return this;
        }

        public InvocationSettingsBuilder setGenerateDiffs(boolean generateDiffs) {
            this.generateDiffs = generateDiffs;
            return this;
        }

        public InvocationSettingsBuilder setBenchmark(boolean benchmark) {
            this.benchmark = benchmark;
            return this;
        }

        public InvocationSettingsBuilder setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public InvocationSettingsBuilder setScenarioFile(File scenarioFile) {
            this.scenarioFile = scenarioFile;
            return this;
        }

        public InvocationSettingsBuilder setOutputDir(File outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public InvocationSettingsBuilder setInvoker(BuildInvoker invoker) {
            this.invoker = invoker;
            return this;
        }

        public InvocationSettingsBuilder setVersions(List<String> versions) {
            this.versions = versions;
            return this;
        }

        public InvocationSettingsBuilder setTargets(List<String> targets) {
            this.targets = targets;
            return this;
        }

        public InvocationSettingsBuilder setSysProperties(Map<String, String> sysProperties) {
            this.sysProperties = sysProperties;
            return this;
        }

        public InvocationSettingsBuilder setGradleUserHome(File gradleUserHome) {
            this.gradleUserHome = gradleUserHome;
            return this;
        }

        public InvocationSettingsBuilder setStudioInstallDir(File studioInstallDir) {
            this.studioInstallDir = studioInstallDir;
            return this;
        }

        public InvocationSettingsBuilder setStudioSandboxDir(@Nullable File studioSandboxDir) {
            this.studioSandboxDir = studioSandboxDir;
            return this;
        }

        public InvocationSettingsBuilder setWarmupCount(Integer warmupCount) {
            this.warmupCount = warmupCount;
            return this;
        }

        public InvocationSettingsBuilder setIterations(Integer iterations) {
            this.iterations = iterations;
            return this;
        }

        public InvocationSettingsBuilder setMeasureGarbageCollection(boolean measureGarbageCollection) {
            this.measureGarbageCollection = measureGarbageCollection;
            return this;
        }

        public InvocationSettingsBuilder setMeasureConfigTime(boolean measureConfigTime) {
            this.measureConfigTime = measureConfigTime;
            return this;
        }

        public InvocationSettingsBuilder setMeasuredBuildOperations(List<String> measuredBuildOperations) {
            this.measuredBuildOperations = measuredBuildOperations;
            return this;
        }

        public InvocationSettingsBuilder setCsvFormat(CsvGenerator.Format csvFormat) {
            this.csvFormat = csvFormat;
            return this;
        }

        public InvocationSettingsBuilder setBenchmarkTitle(@Nullable String benchmarkTitle) {
            this.benchmarkTitle = benchmarkTitle;
            return this;
        }

        public InvocationSettingsBuilder setBuildLog(File buildLog) {
            this.buildLog = buildLog;
            return this;
        }

        public InvocationSettings build() {
            return new InvocationSettings(this.projectDir, this.profiler, this.generateDiffs, this.benchmark, this.outputDir, this.invoker, this.dryRun, this.scenarioFile, this.versions, this.targets, this.sysProperties, this.gradleUserHome, this.studioInstallDir, this.studioSandboxDir, this.warmupCount, this.iterations, this.measureGarbageCollection, this.measureConfigTime, this.measuredBuildOperations, this.csvFormat, this.benchmarkTitle, this.buildLog);
        }
    }
}

