/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.gradle.profiler.CompositeProfilerFactory;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.asyncprofiler.AsyncProfilerAllEventsProfilerFactory;
import org.gradle.profiler.asyncprofiler.AsyncProfilerFactory;
import org.gradle.profiler.asyncprofiler.AsyncProfilerHeapAllocationProfilerFactory;
import org.gradle.profiler.buildscan.BuildScanProfilerFactory;
import org.gradle.profiler.chrometrace.ChromeTraceProfilerFactory;
import org.gradle.profiler.heapdump.HeapDumpProfilerFactory;
import org.gradle.profiler.jfr.JfrProfilerFactory;
import org.gradle.profiler.jprofiler.JProfilerProfilerFactory;
import org.gradle.profiler.yourkit.YourKitHeapAllocationProfilerFactory;
import org.gradle.profiler.yourkit.YourKitSamplingProfilerFactory;
import org.gradle.profiler.yourkit.YourKitTracingProfilerFactory;

public abstract class ProfilerFactory {
    public static final ProfilerFactory NONE = new ProfilerFactory(){

        @Override
        public Profiler createFromOptions(OptionSet parsedOptions) {
            return Profiler.NONE;
        }
    };
    private static final Map<String, ProfilerFactory> AVAILABLE_PROFILERS = Collections.unmodifiableMap(new LinkedHashMap<String, ProfilerFactory>(){
        {
            this.put("buildscan", new BuildScanProfilerFactory());
            this.put("jfr", new JfrProfilerFactory());
            this.put("jprofiler", new JProfilerProfilerFactory());
            this.put("yourkit", new YourKitSamplingProfilerFactory());
            this.put("yourkit-tracing", new YourKitTracingProfilerFactory());
            this.put("yourkit-heap", new YourKitHeapAllocationProfilerFactory());
            this.put("async-profiler", AsyncProfilerFactory.INSTANCE);
            this.put("async-profiler-heap", AsyncProfilerHeapAllocationProfilerFactory.INSTANCE);
            this.put("async-profiler-all", AsyncProfilerAllEventsProfilerFactory.INSTANCE);
            this.put("heap-dump", new HeapDumpProfilerFactory());
            this.put("chrome-trace", new ChromeTraceProfilerFactory());
        }
    });

    public static Set<String> getAvailableProfilers() {
        return AVAILABLE_PROFILERS.keySet();
    }

    public static void configureParser(OptionParser parser) {
        for (ProfilerFactory profiler : AVAILABLE_PROFILERS.values()) {
            profiler.addOptions(parser);
        }
    }

    private static ProfilerFactory of(String name) {
        ProfilerFactory profiler = AVAILABLE_PROFILERS.get(name.toLowerCase());
        if (profiler == null) {
            throw new IllegalArgumentException("Unknown profiler : " + name);
        }
        return profiler;
    }

    public static ProfilerFactory of(List<String> profilersList) {
        if (profilersList.size() == 1) {
            String first = profilersList.get(0);
            return ProfilerFactory.of(first);
        }
        return new CompositeProfilerFactory(profilersList.stream().map(ProfilerFactory::of).collect(Collectors.toList()));
    }

    public abstract Profiler createFromOptions(OptionSet var1);

    public void addOptions(OptionParser parser) {
    }
}

