/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.IOException;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.GradleBuildInvocationResult;
import org.gradle.profiler.GradleScenarioDefinition;
import org.gradle.profiler.ProfilerController;

public class RecordingBuildStepAction
implements BuildStepAction<GradleBuildInvocationResult> {
    private final BuildStepAction<GradleBuildInvocationResult> action;
    private final BuildStepAction<?> cleanupAction;
    private final GradleScenarioDefinition scenario;
    private final ProfilerController controller;

    public RecordingBuildStepAction(BuildStepAction<GradleBuildInvocationResult> action, BuildStepAction<?> cleanupAction, GradleScenarioDefinition scenario, ProfilerController controller) {
        this.action = action;
        this.cleanupAction = cleanupAction;
        this.scenario = scenario;
        this.controller = controller;
    }

    @Override
    public boolean isDoesSomething() {
        return this.action.isDoesSomething();
    }

    @Override
    public GradleBuildInvocationResult run(BuildContext buildContext, BuildStep buildStep) {
        if (buildContext.getIteration() == 1 || this.cleanupAction.isDoesSomething()) {
            try {
                this.controller.startRecording();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        GradleBuildInvocationResult result = this.action.run(buildContext, buildStep);
        if (buildContext.getIteration() == this.scenario.getBuildCount() || this.cleanupAction.isDoesSomething()) {
            try {
                this.controller.stopRecording(result.getDaemonPid());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

