/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.buildops;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.profiler.instrument.GradleInstrumentation;

public class BuildOperationInstrumentation
extends GradleInstrumentation {
    private final boolean measureGarbageCollection;
    private final File totalGarbageCollectionTimeDataFile;
    private final boolean measureConfigTime;
    private final File configurationTimeDataFile;
    private final Map<String, File> buildOperationDataFiles;

    public BuildOperationInstrumentation(boolean measureGarbageCollection, boolean measureConfigTime, List<String> measuredBuildOperations) throws IOException {
        this.measureGarbageCollection = measureGarbageCollection;
        this.totalGarbageCollectionTimeDataFile = File.createTempFile("gradle-profiler", "gc-time");
        this.measureConfigTime = measureConfigTime;
        this.configurationTimeDataFile = File.createTempFile("gradle-profiler", "build-ops-config-time");
        this.configurationTimeDataFile.deleteOnExit();
        this.buildOperationDataFiles = measuredBuildOperations.stream().collect(Collectors.toMap(Function.identity(), BuildOperationInstrumentation::createBuildOperationTempFile));
    }

    public boolean requiresInitScript() {
        return this.measureGarbageCollection || this.measureConfigTime || !this.buildOperationDataFiles.isEmpty();
    }

    private static File createBuildOperationTempFile(String op) {
        try {
            File tempFile = Files.createTempFile("gradle-profiler", "build-ops-" + op, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void generateInitScriptBody(PrintWriter writer) {
        writer.print("new org.gradle.trace.buildops.BuildOperationTrace(gradle)");
        if (this.measureGarbageCollection) {
            writer.print(".measureGarbageCollection(" + this.newFile(this.totalGarbageCollectionTimeDataFile) + ")");
        }
        if (this.measureConfigTime) {
            writer.print(".measureConfigurationTime(" + this.newFile(this.configurationTimeDataFile) + ")");
        }
        if (!this.buildOperationDataFiles.isEmpty()) {
            writer.print(".measureBuildOperations(");
            this.buildOperationDataFiles.forEach((opName, dataFile) -> writer.print(String.format("'%s': %s,", opName, this.newFile((File)dataFile))));
            writer.print(")");
        }
    }

    private String newFile(File dataFile) {
        return "new File(new URI('" + dataFile.toURI() + "'))";
    }

    public Optional<Duration> getTotalGarbageCollectionTime() {
        if (this.totalGarbageCollectionTimeDataFile.length() == 0L) {
            return Optional.empty();
        }
        return Optional.of(BuildOperationInstrumentation.readCumulativeTimeFromDataFile(this.totalGarbageCollectionTimeDataFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Duration> getTimeToTaskExecution() {
        if (this.configurationTimeDataFile.length() == 0L) {
            return Optional.empty();
        }
        try (Stream<String> lines = Files.lines(this.configurationTimeDataFile.toPath(), StandardCharsets.UTF_8);){
            Optional<Duration> optional = lines.reduce((first, second) -> second).map(line -> Duration.ofMillis(Long.parseLong(line)));
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read result from file.", e);
        }
    }

    public Map<String, Duration> getCumulativeBuildOperationTimes() {
        return this.buildOperationDataFiles.entrySet().stream().filter(entry -> ((File)entry.getValue()).length() > 0L).collect(Collectors.toMap(Map.Entry::getKey, entry -> BuildOperationInstrumentation.readCumulativeTimeFromDataFile((File)entry.getValue())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Duration readCumulativeTimeFromDataFile(File dataFile) {
        try (Stream<String> lines = Files.lines(dataFile.toPath(), StandardCharsets.UTF_8);){
            Duration duration = Duration.ofMillis(lines.mapToLong(Long::parseLong).sum());
            return duration;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read result from file.", e);
        }
    }
}

