/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jprofiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.jprofiler.JProfiler;
import org.gradle.profiler.jprofiler.JProfilerConfig;
import org.gradle.profiler.jprofiler.JProfilerConfigFileTransformer;

public class JProfilerJvmArgsCalculator
implements JvmArgsCalculator {
    private final JProfilerConfig jProfilerConfig;
    private final ScenarioSettings settings;
    private final boolean startRecordingOnProcessStart;
    private final boolean captureSnapshotOnProcessExit;

    public JProfilerJvmArgsCalculator(JProfilerConfig jProfilerConfig, ScenarioSettings settings, boolean startRecordingOnProcessStart, boolean captureSnapshotOnProcessExit) {
        this.jProfilerConfig = jProfilerConfig;
        this.settings = settings;
        this.startRecordingOnProcessStart = startRecordingOnProcessStart;
        this.captureSnapshotOnProcessExit = captureSnapshotOnProcessExit;
    }

    @Override
    public void calculateJvmArgs(List<String> jvmArgs) {
        int port = JProfilerJvmArgsCalculator.findUnusedPort();
        this.jProfilerConfig.setPort(port);
        jvmArgs.add(this.getAgentPathParameter(port));
    }

    private String getAgentPathParameter(int port) {
        String id;
        File configFile;
        File jprofilerDir = this.getJProfilerDir();
        if (!jprofilerDir.exists()) {
            throw new RuntimeException("JProfiler home directory " + jprofilerDir + " does not exist, please specify a different directory with --jprofiler-home");
        }
        boolean is64Bit = System.getProperty("sun.arch.data.model", "64").equals("64");
        StringBuilder builder = new StringBuilder();
        builder.append("-agentpath:").append(jprofilerDir);
        if (!jprofilerDir.getPath().endsWith(File.separator)) {
            builder.append(File.separator);
        }
        builder.append("bin").append(File.separator);
        if (OperatingSystem.isWindows()) {
            builder.append("windows");
            if (is64Bit) {
                builder.append("-x64");
            }
            builder.append(File.separator);
            builder.append("jprofilerti.dll");
        } else if (OperatingSystem.isMacOS()) {
            builder.append("macos").append(File.separator);
            builder.append("libjprofilerti.jnilib");
        } else if (OperatingSystem.isLinuxX86()) {
            builder.append("linux");
            if (is64Bit) {
                builder.append("-x64");
            } else {
                builder.append("-x86");
            }
            builder.append(File.separator);
            builder.append("libjprofilerti.so");
        } else {
            throw new RuntimeException("Currently only Windows, macOS and Linux-x86 are detected for the native JProfiler agent library");
        }
        builder.append("=offline,");
        String sessionId = this.jProfilerConfig.getSessionId();
        if (sessionId != null) {
            configFile = this.jProfilerConfig.getConfigFile() != null ? new File(this.jProfilerConfig.getConfigFile()) : null;
            id = sessionId;
        } else {
            configFile = this.getConfigFile();
            id = "1";
        }
        builder.append("id=").append(id);
        if (configFile != null) {
            builder.append(",config=").append(this.transformConfigFile(configFile, id));
        }
        builder.append(",sysprop=jprofiler.jmxServerPort=").append(port);
        return builder.toString();
    }

    private File transformConfigFile(File configFile, String id) {
        if (this.startRecordingOnProcessStart) {
            return JProfilerConfigFileTransformer.transform(configFile, id, this.jProfilerConfig, JProfiler.getSnapshotPath(this.settings), this.captureSnapshotOnProcessExit);
        }
        return configFile;
    }

    private File getJProfilerDir() {
        String homeDir = this.jProfilerConfig.getHomeDir();
        if (OperatingSystem.isMacOS() && !new File(homeDir, "bin").exists()) {
            return new File(homeDir, "Contents/Resources/app");
        }
        return new File(homeDir);
    }

    private File getConfigFile() {
        try {
            String resourceName = "/jprofiler/config/" + this.jProfilerConfig.getConfig() + ".xml";
            URL resource = this.getClass().getResource(resourceName);
            if (resource == null) {
                throw new RuntimeException("Classpath resource \"" + resourceName + "\" not found");
            }
            Path tmpPath = Files.createTempFile("jprofiler", ".xml", new FileAttribute[0]);
            try (InputStream inputStream = resource.openStream();){
                Files.copy(inputStream, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            }
            File tmpFile = tmpPath.toFile();
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JProfiler config file.", e);
        }
    }

    private static int findUnusedPort() {
        int sa2;
        ServerSocket ss = null;
        try {
            if (OperatingSystem.isWindows() || OperatingSystem.isMacOS()) {
                ss = new ServerSocket();
                InetSocketAddress sa2 = new InetSocketAddress("127.0.0.1", 0);
                ss.bind(sa2);
                ss.setReuseAddress(true);
                int n = ss.getLocalPort();
                return n;
            }
            ss = new ServerSocket(0);
            ss.setReuseAddress(true);
            sa2 = ss.getLocalPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find an unused port", e);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sa2;
    }
}

