/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio;

import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.Pair;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.client.protocol.ServerConnection;
import org.gradle.profiler.client.protocol.messages.GradleInvocationCompleted;
import org.gradle.profiler.client.protocol.messages.GradleInvocationParameters;
import org.gradle.profiler.client.protocol.messages.Message;
import org.gradle.profiler.client.protocol.messages.StudioRequest;
import org.gradle.profiler.client.protocol.messages.StudioSyncRequestCompleted;
import org.gradle.profiler.instrument.GradleInstrumentation;
import org.gradle.profiler.studio.invoker.StudioBuildActionResult;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;
import org.gradle.profiler.studio.process.StudioProcess;
import org.gradle.profiler.studio.process.StudioProcessController;
import org.gradle.profiler.studio.tools.StudioPluginInstaller;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class StudioGradleClient
implements GradleClient {
    private static final Duration CACHE_CLEANUP_COMPLETED_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration GRADLE_INVOCATION_STARTED_TIMEOUT = Duration.ofMillis(100L);
    private static final Duration GRADLE_INVOCATION_COMPLETED_TIMEOUT = Duration.ofMinutes(60L);
    private static final Duration SYNC_REQUEST_COMPLETED_TIMEOUT = Duration.ofMinutes(90L);
    private final StudioProcessController processController;
    private final StudioPluginInstaller studioPluginInstaller;
    private final CleanCacheMode cleanCacheMode;
    private final ExecutorService executor;
    private final StudioSandboxCreator.StudioSandbox sandbox;
    private boolean isFirstRun = true;

    public StudioGradleClient(StudioGradleScenarioDefinition.StudioGradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings, CleanCacheMode cleanCacheMode) {
        this.cleanCacheMode = cleanCacheMode;
        Path studioInstallDir = invocationSettings.getStudioInstallDir().toPath();
        Optional<File> studioSandboxDir = invocationSettings.getStudioSandboxDir();
        this.sandbox = StudioSandboxCreator.createSandbox(studioSandboxDir.map(File::toPath).orElse(null));
        Path protocolJar = GradleInstrumentation.unpackPlugin("client-protocol").toPath();
        Path studioPlugin = GradleInstrumentation.unpackPlugin("studio-plugin").toPath();
        this.studioPluginInstaller = new StudioPluginInstaller(this.sandbox.getPluginsDir());
        this.studioPluginInstaller.installPlugin(Arrays.asList(studioPlugin, protocolJar));
        this.processController = new StudioProcessController(studioInstallDir, this.sandbox, invocationSettings, buildConfiguration);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public BuildAction.BuildActionResult sync(List<String> gradleArgs, List<String> jvmArgs) {
        if (this.shouldCleanCache()) {
            this.processController.runAndWaitToStop(connections -> {
                System.out.println("* Cleaning Android Studio cache, this will require a restart...");
                connections.getPluginConnection().send((Message)new StudioRequest(StudioRequest.StudioRequestType.CLEANUP_CACHE));
                connections.getPluginConnection().receiveCacheCleanupCompleted(CACHE_CLEANUP_COMPLETED_TIMEOUT);
                connections.getPluginConnection().send((Message)new StudioRequest(StudioRequest.StudioRequestType.EXIT_IDE));
            });
        }
        this.isFirstRun = false;
        return this.processController.run(connections -> {
            System.out.println("* Running sync in Android Studio...");
            connections.getPluginConnection().send((Message)new StudioRequest(StudioRequest.StudioRequestType.SYNC));
            System.out.println("* Sent sync request");
            Pair<StudioSyncRequestCompleted, StudioBuildActionResult> pair = this.waitForSyncToFinish((StudioProcess.StudioConnections)connections, gradleArgs, jvmArgs);
            StudioSyncRequestCompleted syncRequestResult = (StudioSyncRequestCompleted)pair.getLeft();
            StudioBuildActionResult durationResult = (StudioBuildActionResult)pair.getRight();
            System.out.printf("* Full Gradle execution time: %dms%n", durationResult.getGradleTotalExecutionTime().toMillis());
            System.out.printf("* Full IDE execution time: %dms%n", durationResult.getIdeExecutionTime().toMillis());
            System.out.printf("* Full sync has completed in: %dms and it %s%n", durationResult.getExecutionTime().toMillis(), syncRequestResult.getResult());
            this.maybeThrownExceptionOnSyncFailure(syncRequestResult);
            return durationResult;
        });
    }

    private void maybeThrownExceptionOnSyncFailure(StudioSyncRequestCompleted syncRequestResult) {
        if (syncRequestResult.getResult() == StudioSyncRequestCompleted.StudioSyncRequestResult.FAILED) {
            throw new IllegalStateException(String.format("Gradle sync has failed with error message: '%s'. Full Android Studio logs can be found in: '%s'.", syncRequestResult.getErrorMessage(), new File(this.sandbox.getLogsDir().toFile(), "idea.log").getAbsolutePath()));
        }
    }

    private Pair<StudioSyncRequestCompleted, StudioBuildActionResult> waitForSyncToFinish(StudioProcess.StudioConnections connections, List<String> gradleArgs, List<String> jvmArgs) {
        System.out.println("* Sync has started, waiting for it to complete...");
        AtomicBoolean isSyncRequestCompleted = new AtomicBoolean();
        CompletableFuture<List> gradleInvocations = CompletableFuture.supplyAsync(() -> this.collectGradleInvocations(connections, isSyncRequestCompleted, gradleArgs, jvmArgs), this.executor);
        StudioSyncRequestCompleted syncRequestCompleted = connections.getPluginConnection().receiveSyncRequestCompleted(SYNC_REQUEST_COMPLETED_TIMEOUT);
        isSyncRequestCompleted.set(true);
        List gradleInvocationDurations = gradleInvocations.join();
        long totalGradleDuration = gradleInvocationDurations.stream().mapToLong(Duration::toMillis).sum();
        StudioBuildActionResult result = new StudioBuildActionResult(Duration.ofMillis(syncRequestCompleted.getDurationMillis()), Duration.ofMillis(totalGradleDuration), gradleInvocationDurations, Duration.ofMillis(syncRequestCompleted.getDurationMillis() - totalGradleDuration));
        return Pair.of((Object)syncRequestCompleted, (Object)result);
    }

    private List<Duration> collectGradleInvocations(StudioProcess.StudioConnections connections, AtomicBoolean isSyncRequestCompleted, List<String> gradleArgs, List<String> jvmArgs) {
        ArrayList<Duration> durations = new ArrayList<Duration>();
        int invocation = 1;
        ServerConnection agentConnection = connections.getAgentConnection();
        while (!isSyncRequestCompleted.get()) {
            Optional invocationStarted = agentConnection.maybeReceiveGradleInvocationStarted(GRADLE_INVOCATION_STARTED_TIMEOUT);
            if (!invocationStarted.isPresent()) continue;
            System.out.printf("* Gradle invocation %s has started, waiting for it to complete...%n", invocation);
            agentConnection.send((Message)new GradleInvocationParameters(gradleArgs, jvmArgs));
            GradleInvocationCompleted agentCompleted = agentConnection.receiveGradleInvocationCompleted(GRADLE_INVOCATION_COMPLETED_TIMEOUT);
            System.out.printf("* Gradle invocation %s has completed in: %sms%n", invocation++, agentCompleted.getDurationMillis());
            durations.add(Duration.ofMillis(agentCompleted.getDurationMillis()));
        }
        return durations;
    }

    private boolean shouldCleanCache() {
        return this.isFirstRun && this.cleanCacheMode == CleanCacheMode.BEFORE_SCENARIO || this.cleanCacheMode == CleanCacheMode.BEFORE_BUILD;
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            if (this.processController.isProcessRunning()) {
                this.processController.runAndWaitToStop(connections -> {
                    System.out.println("* Stopping Android Studio....");
                    connections.getPluginConnection().send((Message)new StudioRequest(StudioRequest.StudioRequestType.EXIT_IDE));
                    System.out.println("* Android Studio stopped.");
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("* Android Studio did not finish successfully, you will have to close it manually.");
        }
        finally {
            this.studioPluginInstaller.uninstallPlugin();
        }
    }

    public static enum CleanCacheMode {
        BEFORE_SCENARIO,
        BEFORE_BUILD,
        NEVER;

    }
}

