/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.invoker;

import java.time.Duration;
import java.util.List;
import org.gradle.profiler.GradleBuildInvocationResult;
import org.gradle.profiler.result.Sample;
import org.gradle.profiler.studio.invoker.StudioBuildActionResult;

public class StudioBuildInvocationResult
extends GradleBuildInvocationResult {
    public static final Sample<StudioBuildInvocationResult> GRADLE_TOTAL_EXECUTION_TIME = new Sample<StudioBuildInvocationResult>(){

        @Override
        public String getName() {
            return "Gradle total execution time";
        }

        @Override
        public Duration extractFrom(StudioBuildInvocationResult result) {
            return result.getActionResult().getGradleTotalExecutionTime();
        }
    };
    public static final Sample<StudioBuildInvocationResult> IDE_EXECUTION_TIME = new Sample<StudioBuildInvocationResult>(){

        @Override
        public String getName() {
            return "IDE execution time";
        }

        @Override
        public Duration extractFrom(StudioBuildInvocationResult result) {
            return result.getActionResult().getIdeExecutionTime();
        }
    };

    public StudioBuildInvocationResult(GradleBuildInvocationResult result) {
        super(result.getBuildContext(), result.getActionResult(), result.getGarbageCollectionTime(), result.getTimeToTaskExecution(), result.getCumulativeBuildOperationTimes(), result.getDaemonPid());
    }

    @Override
    public StudioBuildActionResult getActionResult() {
        return (StudioBuildActionResult)super.getActionResult();
    }

    public static Sample<StudioBuildInvocationResult> getGradleToolingAgentExecutionTime(final int index) {
        return new Sample<StudioBuildInvocationResult>(){

            @Override
            public String getName() {
                return "Gradle execution time #" + (index + 1);
            }

            @Override
            public Duration extractFrom(StudioBuildInvocationResult result) {
                List<Duration> executionTimes = result.getActionResult().getGradleExecutionTimes();
                return index >= executionTimes.size() ? Duration.ZERO : executionTimes.get(index);
            }
        };
    }
}

