/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import com.google.common.base.Joiner;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.profiler.instrument.GradleInstrumentation;
import org.gradle.profiler.studio.launcher.LaunchConfiguration;
import org.gradle.profiler.studio.launcher.StudioConfiguration;
import org.gradle.profiler.studio.launcher.StudioConfigurationProvider;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class LauncherConfigurationParser {
    private static final boolean SHOULD_RUN_HEADLESS = Boolean.getBoolean("studio.tests.headless");
    private final Path studioInstallDir;
    private final StudioSandboxCreator.StudioSandbox studioSandbox;
    private final List<String> studioJvmArgs;
    private boolean enableStudioPluginParameters;
    private int studioPluginPort;
    private boolean enableStudioAgentParameters;
    private int studioAgentPort;
    private int studioStartDetectorPort;

    public LauncherConfigurationParser(Path studioInstallDir, StudioSandboxCreator.StudioSandbox studioSandbox, List<String> studioJvmArgs) {
        this.studioInstallDir = studioInstallDir;
        this.studioSandbox = studioSandbox;
        this.studioJvmArgs = studioJvmArgs;
    }

    public LauncherConfigurationParser withStudioPluginParameters(int studioStartDetectorPort, int studioPluginPort) {
        this.enableStudioPluginParameters = true;
        this.studioStartDetectorPort = studioStartDetectorPort;
        this.studioPluginPort = studioPluginPort;
        return this;
    }

    public LauncherConfigurationParser withStudioAgentParameters(int studioAgentPort) {
        this.enableStudioAgentParameters = true;
        this.studioAgentPort = studioAgentPort;
        return this;
    }

    public LaunchConfiguration calculate() {
        StudioConfiguration studioConfiguration = StudioConfigurationProvider.getLaunchConfiguration(this.studioInstallDir);
        Map<String, String> systemProperties = this.buildSystemProperties(studioConfiguration.getSystemProperties());
        Path javaCommand = studioConfiguration.getJavaCommand();
        Path actualInstallDir = studioConfiguration.getActualInstallDir();
        Path agentJar = GradleInstrumentation.unpackPlugin("studio-agent").toPath();
        Path asmJar = GradleInstrumentation.unpackPlugin("asm").toPath();
        Path supportJar = GradleInstrumentation.unpackPlugin("instrumentation-support").toPath();
        Path protocolJar = GradleInstrumentation.unpackPlugin("client-protocol").toPath();
        Path studioPlugin = GradleInstrumentation.unpackPlugin("studio-plugin").toPath();
        Path studioPluginsDir = this.studioSandbox.getPluginsDir();
        Path studioLogsDir = this.studioSandbox.getLogsDir();
        List<Path> sharedJars = Arrays.asList(asmJar, protocolJar);
        List<Path> studioPluginJars = Arrays.asList(studioPlugin, protocolJar);
        String mainClass = studioConfiguration.getMainClass();
        List<Path> classpath = studioConfiguration.getClasspath();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(javaCommand.toString());
        commandLine.add("-cp");
        commandLine.add(Joiner.on((String)File.pathSeparator).join(classpath));
        systemProperties.forEach((key, value) -> commandLine.add(String.format("-D%s=%s", key, value)));
        if (this.enableStudioAgentParameters) {
            commandLine.add(String.format("-javaagent:%s=%s,%s", agentJar, this.studioAgentPort, supportJar));
            commandLine.add("--add-exports");
            commandLine.add("java.base/jdk.internal.misc=ALL-UNNAMED");
            commandLine.add("-Xbootclasspath/a:" + Joiner.on((String)File.pathSeparator).join(sharedJars));
        }
        commandLine.addAll(this.studioJvmArgs);
        commandLine.add(mainClass);
        if (SHOULD_RUN_HEADLESS) {
            commandLine.add("headless-starter");
        }
        return new LaunchConfiguration(javaCommand, actualInstallDir, classpath, systemProperties, mainClass, agentJar, supportJar, sharedJars, studioPluginJars, studioPluginsDir, studioLogsDir, commandLine);
    }

    private Map<String, String> buildSystemProperties(Map<String, String> studioSystemProperties) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(studioSystemProperties);
        if (this.enableStudioPluginParameters) {
            systemProperties.put("gradle.profiler.startup.port", String.valueOf(this.studioStartDetectorPort));
            systemProperties.put("gradle.profiler.port", String.valueOf(this.studioPluginPort));
        }
        this.studioSandbox.getConfigDir().ifPresent(path -> systemProperties.put("idea.config.path", path.toString()));
        this.studioSandbox.getSystemDir().ifPresent(path -> systemProperties.put("idea.system.path", path.toString()));
        systemProperties.put("idea.plugins.path", this.studioSandbox.getPluginsDir().toString());
        systemProperties.put("idea.log.path", this.studioSandbox.getLogsDir().toString());
        if (SHOULD_RUN_HEADLESS) {
            systemProperties.put("java.awt.headless", "true");
        }
        return systemProperties;
    }
}

