/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import org.gradle.profiler.CliGradleClient;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ToolingApiGradleClient;
import org.gradle.profiler.studio.StudioGradleClient;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;

public enum GradleClientSpec {
    ToolingApi("Tooling API"){

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            GradleConnector connector = GradleConnector.newConnector().useInstallation(buildConfiguration.getGradleHome()).useGradleUserHomeDir(invocationSettings.getGradleUserHome().getAbsoluteFile());
            ProjectConnection projectConnection = connector.forProjectDirectory(invocationSettings.getProjectDir()).connect();
            return new ToolingApiGradleClient(projectConnection);
        }
    }
    ,
    GradleCli("`gradle` command"){

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            return new CliGradleClient(buildConfiguration, buildConfiguration.getJavaHome(), invocationSettings.getProjectDir(), true, invocationSettings.getBuildLog());
        }
    }
    ,
    GradleCliNoDaemon("`gradle` command with --no-daemon"){

        @Override
        public boolean isUsesDaemon() {
            return false;
        }

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            return new CliGradleClient(buildConfiguration, buildConfiguration.getJavaHome(), invocationSettings.getProjectDir(), false, invocationSettings.getBuildLog());
        }
    }
    ,
    AndroidStudio("Android Studio"){

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            return new StudioGradleClient((StudioGradleScenarioDefinition.StudioGradleBuildConfiguration)buildConfiguration, invocationSettings, StudioGradleClient.CleanCacheMode.NEVER);
        }
    }
    ,
    AndroidStudioCleanCacheBeforeBuild("Android Studio with clean cache before build"){

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            return new StudioGradleClient((StudioGradleScenarioDefinition.StudioGradleBuildConfiguration)buildConfiguration, invocationSettings, StudioGradleClient.CleanCacheMode.BEFORE_BUILD);
        }
    }
    ,
    AndroidStudioCleanCacheBeforeScenario("Android Studio with clean cache before scenario"){

        @Override
        public GradleClient create(GradleBuildConfiguration buildConfiguration, InvocationSettings invocationSettings) {
            return new StudioGradleClient((StudioGradleScenarioDefinition.StudioGradleBuildConfiguration)buildConfiguration, invocationSettings, StudioGradleClient.CleanCacheMode.BEFORE_SCENARIO);
        }
    };

    private final String title;

    private GradleClientSpec(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public boolean isUsesDaemon() {
        return true;
    }

    public abstract GradleClient create(GradleBuildConfiguration var1, InvocationSettings var2);
}

