/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractCacheCleanupMutator;
import org.gradle.profiler.mutations.AbstractCleanupMutator;

public class ClearBuildCacheMutator
extends AbstractCacheCleanupMutator {
    public ClearBuildCacheMutator(File gradleUserHome, AbstractCleanupMutator.CleanupSchedule schedule) {
        super(gradleUserHome, schedule, "build-cache-");
    }

    @Override
    protected void cleanupCacheDir(File cacheDir) {
        Arrays.stream((Object[])Objects.requireNonNull(cacheDir.listFiles(file -> file.getName().length() == 32))).forEach(AbstractCleanupMutator::delete);
    }

    public static class Configurator
    extends AbstractCleanupMutator.Configurator {
        @Override
        protected BuildMutator newInstance(Config scenario, String scenarioName, InvocationSettings settings, String key, AbstractCleanupMutator.CleanupSchedule schedule) {
            return new ClearBuildCacheMutator(settings.getGradleUserHome(), schedule);
        }
    }
}

